<?php

/**
 * version-check.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU General Public License v2 or later
 * @copyright Copyright (c) 2013-2016 Dominik Kocuj
 * @package kocuj_sitemap
 */

// set namespace
namespace KocujSitemapPlugin\Classes\KocujILStrings\Backend;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * \KocujIL\V6a\Classes\Project\Components\Backend\VersionCheck classes strings
 *
 * @access public
 */
class VersionCheck implements \KocujIL\V6a\Interfaces\Strings {
	/**
	 * Singleton instance
	 *
	 * @access private
	 * @var object
	 */
	private static $instance = NULL;

	/**
	 * Constructor
	 *
	 * @access private
	 * @return void
	 */
	private function __construct() {
	}

	/**
	 * Disable cloning of object
	 *
	 * @access private
	 * @return void
	 */
	private function __clone() {
	}

	/**
	 * Get singleton instance
	 *
	 * @access public
	 * @return object Singleton instance
	 */
	public static function getInstance() {
		// optionally create new instance
		if (!self::$instance) {
			self::$instance = new self();
		}
		// exit
		return self::$instance;
	}

	/**
	 * Get string
	 *
	 * @access public
	 * @param string $id String id
	 * @return string Output string
	 */
	public function getString($id) {
		// get string
		$texts = array(
			'ACTION_ADMIN_INIT_SCRIPT_LOADING'       => __('Loading, please wait...', 'kocuj-sitemap'),
			'ACTION_ADMIN_INIT_SCRIPT_LOADING_ERROR' => __('Loading error! Please, check your internet connection and refresh page to try again.', 'kocuj-sitemap'),
			/* translators: 1: version of this plugin, 2: plugin name */
			'ACTION_ADMIN_INIT_SCRIPT_TITLE_PLUGIN'  => __('Changes in %1$s version of %2$s plugin', 'kocuj-sitemap'),
			/* translators: 1: version of this theme, 2: theme name */
			'ACTION_ADMIN_INIT_SCRIPT_TITLE_THEME'   => __('Changes in %1$s version of %2$s theme', 'kocuj-sitemap'),
			/* translators: 1: plugin name, 2: beginning of the link to update information, 3: ending of the link to update information */
			'ACTION_ADMIN_INIT_TOP_MESSAGE_PLUGIN'   => __('There are some new information about new version of the %1$s plugin. Click %2$shere%3$s to see these information.', 'kocuj-sitemap'),
			/* translators: 1: theme name, 2: beginning of the link to update information, 3: ending of the link to update information */
			'ACTION_ADMIN_INIT_TOP_MESSAGE_THEME'    => __('There are some new information about new version of the %1$s theme. Click %2$shere%3$s to see these information.', 'kocuj-sitemap'),
		);
		// exit
		return (isset($texts[$id])) ?
			$texts[$id] :
			'';
	}
}
