<?php

/**
 * kocuj-internal-lib.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU General Public License v2 or later
 * @copyright Copyright (c) 2016 Dominik Kocuj
 * @package kocuj_internal_lib
 */

// set namespace
namespace KocujIL\V6a;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

// load library if do not exists already
if (!class_exists('\\KocujIL\\V6a\\Classes\\Project', false)) {
	// initialize directories
	include dirname(__FILE__).DIRECTORY_SEPARATOR.'classes'.DIRECTORY_SEPARATOR.'lib-dirs.class.php';
	\KocujIL\V6a\Classes\LibDirs::getInstance();

	/**
	 * Automatic loading of classes
	 *
	 * @access public
	 * @param string $class Class name
	 * @param string $requiredPrefix Required class prefix; if empty "KocujIL\V6a\" will be used - default: empty
	 * @param string $mainDir Main directory with classes; if empty, main directory for Kocuj Internal Lib will be used - default: empty
	 * @return void
	 */
	function autoload($class, $requiredPrefix = '', $mainDir = '') {
		// initialize
		if (!isset($requiredPrefix[0]) /* strlen($requiredPrefix) === 0 */ ) {
			$requiredPrefix = 'KocujIL\\V6a\\';
		}
		if (!isset($mainDir[0]) /* strlen($mainDir) === 0 */ ) {
			$mainDir = \KocujIL\V6a\Classes\LibDirs::getInstance()->getMain();
		}
		// load class
		if (substr($class, 0, strlen($requiredPrefix)) === $requiredPrefix) {
			$div = explode('\\', $class);
			$count = count($div);
			$filename = $div[$count-1];
			unset($div[$count-1], $div[1], $div[0]);
			$dirArray = preg_replace('/([A-Z])/', '-$1', $div);
			if (!empty($dirArray)) {
				foreach ($dirArray as $key => $val) {
					$dirArray[$key] = substr($val, 1);
				}
			}
			set_include_path($mainDir.DIRECTORY_SEPARATOR.strtolower(implode(DIRECTORY_SEPARATOR, $dirArray)));
			spl_autoload(strtolower(substr(preg_replace('/([A-Z])/', '-$1', $filename), 1)), '.class.php');
			restore_include_path();
		}
	}

	// set automatic loading of classes
	spl_autoload_register('\\KocujIL\\V6a\\autoload');

	// initialize required classes
	\KocujIL\V6a\Classes\JsHelper::getInstance();
}
