<?php

/**
 * component.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU General Public License v2 or later
 * @copyright Copyright (c) 2016 Dominik Kocuj
 * @package kocuj_internal_lib\kocuj_pl_lib
 */

// set namespace
namespace KocujPlLib\V6a\Classes\Project\Components\Backend\AddThanks;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Adding thanks class
 *
 * @access public
 */
class Component extends \KocujIL\V6a\Classes\ComponentObject {
	/**
	 * Option name - thanks added
	 *
	 */
	const OPTION_NAME_THANKS_ADDED = 'thanks_added';

	/**
	 * Adding thanks is set to be displayed (true) or adding thanks will not be displayed (false)
	 *
	 * @access private
	 * @var bool
	 */
	private $addThanksDisplay = false;

	/**
	 * Set adding thanks to display (true) or not (false)
	 *
	 * @access public
	 * @param bool $addThanksDisplay Adding thanks will be displayed (true) or not (false)
	 * @return void
	 */
	public function setAddThanksDisplay($addThanksDisplay) {
		// set value
		$this->addThanksDisplay = $addThanksDisplay;
		// add "scripts
		if ($addThanksDisplay) {
			\KocujIL\V6a\Classes\JsHelper::getInstance()->addHelperJs();
			if (\KocujIL\V6a\Classes\JsHelper::getInstance()->getThrowErrors()) {
				\KocujIL\V6a\Classes\JsHelper::getInstance()->addExceptionJs();
			}
			\KocujIL\V6a\Classes\JsHelper::getInstance()->addModalJs();
			$this->getProjectObj()->getProjectKocujILObj()->get('all', 'js-ajax')->addAjaxJs();
			if (\KocujIL\V6a\Classes\JsHelper::getInstance()->getThrowErrors()) {
				\KocujIL\V6a\Classes\JsHelper::getInstance()->addScript(\KocujPlLib\V6a\Classes\Helper::getInstance()->getPrefix().'-exception-code', \KocujPlLib\V6a\Classes\LibUrls::getInstance()->get('js'), 'exception-code', array(), array(), \KocujPlLib\V6a\Classes\Version::getInstance()->getVersion(), true);
				\KocujIL\V6a\Classes\JsHelper::getInstance()->addScript(\KocujPlLib\V6a\Classes\Helper::getInstance()->getPrefix().'-exception', \KocujPlLib\V6a\Classes\LibUrls::getInstance()->get('js'), 'exception', array(), array(
					\KocujIL\V6a\Classes\Helper::getInstance()->getPrefix().'-exception',
					\KocujPlLib\V6a\Classes\Helper::getInstance()->getPrefix().'-exception-code',
				), \KocujPlLib\V6a\Classes\Version::getInstance()->getVersion(), true);
			}
		}
	}

	/**
	 * Get if thanks has been added (true) or not (false)
	 *
	 * @access public
	 * @return bool Thanks has been added (true) or not (false)
	 */
	public function getThanksAddedOptionValue() {
		// exit
		return ($this->getProjectObj()->getProjectKocujILObj()->get('core', 'meta')->get(self::OPTION_NAME_THANKS_ADDED) === false) ?
			false :
			true;
	}

	/**
	 * Action for adding JavaScript scripts
	 *
	 * @access public
	 * @return void
	 */
	public function actionAdminFooter() {
		// add scripts
		if ((!$this->getThanksAddedOptionValue()) && ($this->addThanksDisplay)) {
			\KocujIL\V6a\Classes\JsHelper::getInstance()->addScript(\KocujPlLib\V6a\Classes\Helper::getInstance()->getPrefix().'-backend-add-thanks', \KocujPlLib\V6a\Classes\LibUrls::getInstance()->get('js').'/project/components/backend/add-thanks', 'add-thanks', array(
				'helper',
				'modal',
			), array(
				\KocujIL\V6a\Classes\Helper::getInstance()->getPrefix().'-all-js-ajax',
			) , \KocujPlLib\V6a\Classes\Version::getInstance()->getVersion(), true, true, 'kocujPLV6aBackendAddThanksVals', array(
				'prefix'                 => \KocujPlLib\V6a\Classes\Helper::getInstance()->getPrefix(),
				'prefixKocujIL'          => \KocujIL\V6a\Classes\Helper::getInstance()->getPrefix(),
				'security'               => wp_create_nonce(\KocujPlLib\V6a\Classes\Helper::getInstance()->getPrefix().'__add_thanks'),
				'websiteUrl'             => get_home_url(),
				'websiteTitle'           => get_bloginfo('name', 'display'),
				'websiteDescription'     => get_bloginfo('description', 'display'),
				'textMoreInfoLink'       => $this->getStrings('backend', 'add-thanks')->getString('ACTION_ADMIN_FOOTER_SCRIPT_MORE_INFO_LINK'),
				'textWindowTitle'        => $this->getStrings('backend', 'add-thanks')->getString('ACTION_ADMIN_FOOTER_SCRIPT_WINDOW_TITLE'),
				'textWindowLoading'      => $this->getStrings('backend', 'add-thanks')->getString('ACTION_ADMIN_FOOTER_SCRIPT_WINDOW_LOADING'),
				'textWindowLoadingError' => $this->getStrings('backend', 'add-thanks')->getString('ACTION_ADMIN_FOOTER_SCRIPT_WINDOW_LOADING_ERROR'),
				'textSending'            => $this->getStrings('backend', 'add-thanks')->getString('ACTION_ADMIN_FOOTER_SCRIPT_SENDING'),
				'textError'              => $this->getStrings('backend', 'add-thanks')->getString('ACTION_ADMIN_FOOTER_SCRIPT_ERROR'),
				'textErrorNoRetries'     => $this->getStrings('backend', 'add-thanks')->getString('ACTION_ADMIN_FOOTER_SCRIPT_ERROR_NO_RETRIES'),
				'textErrorAlreadyExists' => $this->getStrings('backend', 'add-thanks')->getString('ACTION_ADMIN_FOOTER_SCRIPT_ERROR_ALREADY_EXISTS'),
				'textErrorWrongResponse' => $this->getStrings('backend', 'add-thanks')->getString('ACTION_ADMIN_FOOTER_SCRIPT_ERROR_WRONG_RESPONSE'),
				'textSuccess'            => $this->getStrings('backend', 'add-thanks')->getString('ACTION_ADMIN_FOOTER_SCRIPT_SUCCESS'),
				'imageLoadingUrl'        => \KocujPlLib\V6a\Classes\LibUrls::getInstance()->get('images').'/project/components/backend/add-thanks/loading.gif',
			), true);
		}
	}
}
