<?php

/**
 * component.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU General Public License v2 or later
 * @copyright Copyright (c) 2016 Dominik Kocuj
 * @package kocuj_internal_lib
 */

// set namespace
namespace KocujIL\V7a\Classes\Project\Components\Frontend\Admin;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Admin class
 *
 * @access public
 */
class Component extends \KocujIL\V7a\Classes\ComponentObject {
	/**
	 * Constructor
	 *
	 * @access public
	 * @param object $projectObj \KocujIL\V7a\Classes\Project object for current project
	 * @return void
	 */
	public function __construct($projectObj) {
		// execute parent constructor
		parent::__construct($projectObj);
		// initialize configuration
		add_action('init', array($this->getComponent('all', 'config'), 'initAfterAddToAdmin'), 1);
	}
}
