<?php

/**
 * init.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU General Public License v2 or later
 * @copyright Copyright (c) 2016 Dominik Kocuj
 * @package kocuj_internal_lib
 */

// set namespace
namespace KocujIL\V7a\Classes\Project\Components\Backend\SettingsMenu;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Settings menu (component initialization) class
 *
 * @access public
 */
class Init extends \KocujIL\V7a\Classes\ComponentInitObject {
	/**
	 * Constructor
	 *
	 * @access public
	 * @param object $projectObj \KocujIL\V7a\Classes\Project object for current project
	 * @return void
	 */
	public function __construct($projectObj) {
		// execute parent
		parent::__construct($projectObj);
		// add actions
		$this->getComponent('core', 'actions-filters-helper')->addActionWhenNeeded((((is_network_admin())) ?
				'network_' :
				''
			).'admin_menu', 'backend', 'settings-menu', '', 'actionAdminMenu');
		// add filters
		if ($this->getProjectObj()->getMainSettingType() === \KocujIL\V7a\Enums\ProjectType::PLUGIN) {
			$this->getComponent('core', 'actions-filters-helper')->addFilterWhenNeeded((((is_network_admin())) ?
					'network_admin_' :
					''
				).'plugin_action_links', 'backend', 'settings-menu', '', 'filterPluginActionLinks', 10, 2);
		}
	}
}
