<?php

/**
 * init.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU General Public License v2 or later
 * @copyright Copyright (c) 2016 Dominik Kocuj
 * @package kocuj_internal_lib
 */

// set namespace
namespace KocujPlLib\V7a\Classes\Project\Components\Backend\SettingsAdvMetaBoxes;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Settings advertisements meta boxes (component initialization) class
 *
 * @access public
 */
class Init extends \KocujIL\V7a\Classes\ComponentInitObject {
	/**
	 * Required components
	 *
	 * @access protected
	 * @var array
	 */
	protected $requiredComponents = array(
		'KocujIL' => array(
			'backend' => array(
				'settings-meta-boxes',
			),
		),
	);

	/**
	 * Constructor
	 *
	 * @access public
	 * @param object $projectObj \KocujIL\V7a\Classes\Project object for current project
	 * @return void
	 */
	public function __construct($projectObj) {
		// execute parent
		parent::__construct($projectObj);
		// add actions
		$this->getComponent('core', 'actions-filters-helper')->addActionWhenNeeded('admin_init', 'backend', 'settings-adv-meta-boxes', '', 'actionAdminInit', 1);
	}
}
