<?php

/**
 * widget.class.php
 *
 * @author Dominik Kocuj
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU General Public License v2 or later
 * @copyright Copyright (c) 2013-2017 kocuj.pl
 * @package kocuj_sitemap
 */

// set namespace
namespace KocujSitemapPlugin\Classes;

// set namespaces aliases
use KocujIL\V8a as KocujIL;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Widget class
 *
 * @access public
 */
class Widget extends KocujIL\Classes\Project\Components\All\Widget\Widget {
	/**
	 * Sitemap excludes
	 *
	 * @access private
	 * @var array
	 */
	private $excludes = array();

	/**
	 * Constructor
	 *
	 * @access public
	 * @return void
	 */
	public function __construct() {
		// execute parent constructor
		/* translators: %s: Name of this plugin ("Kocuj Sitemap") */
		parent::__construct('widget', __('Sitemap', 'kocuj-sitemap'), array(
			'global_projectobj'  => Base::getInstance()->getKocujILObj(),
			'global_containerid' => 'widget',
			'global_description' => sprintf(__('Sitemap generated by the %s plugin.', 'kocuj-sitemap'), 'Kocuj Sitemap'),
			'global_additional'  => array(
				'defaulttitle'       => __('Sitemap', 'kocuj-sitemap'),
				'optiondisplaytitle' => 'display_title',
				'optiontitle'        => 'title',
			),
		));
		// add options
		$labels = array();
		$this->excludes = Sitemap::getInstance()->getExcludeDefaults($labels, '', 'kocujsitemap_widget_default_exclude_');
		if (!empty($this->excludes)) {
			foreach ($this->excludes as $key => $val) {
				$this->getProjectObj()->get('options', KocujIL\Enums\ProjectCategory::ALL)->addDefinition($this->getContainerId(), 'exclude_'.$key, 'text', '', __('Exclude', 'kocuj-sitemap').' '.implode(', ', ((isset($labels[$key])) ?
						$labels[$key] :
						''
					)));
			}
		}
	}

	/**
	 * Display widget
	 *
	 * @access public
	 * @param array $args Widget arguments
	 * @param array $options Widget options
	 * @return void
	 */
	public function widget($args, $options) {
		// execute parent method
		parent::widget($args, $options);
		// prepare widget output
		$exclude = array();
		if (!empty($this->excludes)) {
			foreach ($this->excludes as $key => $val) {
				$value = $this->getProjectObj()->get('options', KocujIL\Enums\ProjectCategory::ALL)->getOption($this->getContainerId(), 'exclude_'.$key);
				if (!isset($value[0]) /* strlen($value) === 0 */ ) {
					$value = $val;
				}
				$exclude[$key] = explode(',', $value);
			}
		}
		// display widget content
		$this->displayWidgetContent($args, Sitemap::getInstance()->get('', 'kocujsitemapwidget', $exclude, \KocujSitemapPlugin\Enums\Widget::YES));
	}

	/**
	 * Display widget form
	 *
	 * @access public
	 * @param array $options Widget options
	 * @return void
	 */
	public function form($options) {
		// execute parent method
		parent::form($options);
		// add form fields
		if (!empty($this->excludes)) {
			foreach ($this->excludes as $key => $val) {
				$this->getProjectObj()->get('settings-form', KocujIL\Enums\ProjectCategory::BACKEND)->addOptionFieldToTab($this->getContainerId(), $this->getContainerId(), 'text', 'exclude_'.$key, __('Comma separated list of identifiers to exclude in the sitemap.', 'kocuj-sitemap'), array(), array(
					'global_widgetobj' => $this,
				));

			}
		}
		// show form
		$this->displayForm();
	}
}
