<?php

/**
 * component-init-object.class.php
 *
 * @author Dominik Kocuj
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU General Public License v2 or later
 * @copyright Copyright (c) 2016-2017 kocuj.pl
 * @package kocuj_internal_lib
 */

// set namespace
namespace KocujIL\V8a\Classes;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Component object (component initialization) class
 *
 * @access public
 */
class ComponentInitObject extends ComponentObject {
	/**
	 * Required components
	 *
	 * @access protected
	 * @var array
	 */
	protected $requiredComponents = array();

	/**
	 * Errors
	 *
	 * @access protected
	 * @var array
	 */
	protected $errors = array();

	/**
	 * Get required components
	 *
	 * @access public
	 * @return array Required components
	 */
	public function getRequiredComponents() {
		// exit
		return $this->requiredComponents;
	}

	/**
	 * Get errors
	 *
	 * @access public
	 * @return array Errors
	 */
	public function getErrors() {
		// exit
		return $this->errors;
	}
}
