<?php

/**
 * init.class.php
 *
 * @author Dominik Kocuj
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU General Public License v2 or later
 * @copyright Copyright (c) 2016-2017 kocuj.pl
 * @package kocuj_internal_lib
 */

// set namespace
namespace KocujIL\V8a\Classes\Project\Components\All\Version;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Version (component initialization) class
 *
 * @access public
 */
class Init extends \KocujIL\V8a\Classes\ComponentInitObject {
	/**
	 * Constructor
	 *
	 * @access public
	 * @param object $projectObj \KocujIL\V8a\Classes\Project object for current project
	 * @return void
	 */
	public function __construct($projectObj) {
		// execute parent
		parent::__construct($projectObj);
		// add actions
		$this->getComponent('actions-filters-helper')->addActionWhenNeeded('plugins_loaded', \KocujIL\V8a\Enums\ProjectCategory::ALL, 'version', '', 'actionPluginsLoaded', 999);
	}
}
