<?php

/**
 * component.class.php
 *
 * @author Dominik Kocuj
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU General Public License v2 or later
 * @copyright Copyright (c) 2016-2017 kocuj.pl
 * @package kocuj_internal_lib\kocuj_pl_lib
 */

// set namespace
namespace KocujPlLib\V8a\Classes\Project\Components\Backend\ReviewMessageAddThanks;

// set namespaces aliases
use KocujIL\V8a as KocujIL;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Adding thanks from review message class
 *
 * @access public
 */
class Component extends KocujIL\Classes\ComponentObject {
	/**
	 * Review message with adding thanks is set to be displayed (true) or review message with adding thanks will not be displayed (false)
	 *
	 * @access private
	 * @var bool
	 */
	private $reviewMessageAddThanksDisplay = false;

	/**
	 * Action for displaying CSS stylesheet
	 *
	 * @access public
	 * @return void
	 */
	public function adminHead() {
		// check if thanks has not been added already
		if ($this->getComponent('add-thanks', KocujIL\Enums\ProjectCategory::BACKEND)->getThanksAddedOptionValue()) {
			return;
		}
		// add styles
		?>
			<style id="<?php echo esc_attr($this->getComponent('project-helper')->getPrefix().'__add_thanks_review_message_style'); ?>" type="text/css" media="all">
				#<?php echo $this->getComponent('project-helper')->getPrefix(); ?>__add_thanks_review_message_more_info_link_div {
					font-size: 11px;
				}

				.<?php echo $this->getProjectObj()->getProjectKocujILObj()->get('project-helper')->getPrefix(); ?>__review_message_element_div {
					height: 50px;
				}

				@media screen and (max-width: 782px) {
					#<?php echo $this->getComponent('project-helper')->getPrefix(); ?>__add_thanks_review_message_more_info_link_div {
						font-size: 12px;
					}

					.<?php echo $this->getProjectObj()->getProjectKocujILObj()->get('project-helper')->getPrefix(); ?>__review_message_element_div {
						height: auto;
					}
				}
			</style>
		<?php
	}

	/**
	 * Filter for element class in review message
	 *
	 * @access public
	 * @param string $class Class
	 * @return string Class
	 */
	public function filterReviewMessageElementClass($class) {
		// exit
		return $class.((isset($class[0]) /* strlen($class) > 0 */ ) ?
				' ' :
				''
			).$this->getComponent('project-helper')->getPrefix().'__add_thanks_review_message_element_div';
	}

	/**
	 * Filter for elements before other elements in review message
	 *
	 * @access public
	 * @param array $elements Elements
	 * @return array Elements
	 */
	public function filterReviewMessageElementsBefore(array $elements) {
		// check if thanks has not been added already
		if ($this->getComponent('add-thanks', KocujIL\Enums\ProjectCategory::BACKEND)->getThanksAddedOptionValue()) {
			return $elements;
		}
		// add element
		$elements[] = '<input type="button" class="button button-small" id="'.esc_attr($this->getComponent('project-helper')->getPrefix().'__add_thanks_review_message_send').'" value="'.esc_attr($this->getStrings('review-message-add-thanks', KocujIL\Enums\ProjectCategory::BACKEND)->getString('FILTER_REVIEW_MESSAGE_ELEMENTS_BEFORE_ADD_THANKS')).'" />'.
			'<br />'.
			'<div id="'.esc_attr($this->getComponent('project-helper')->getPrefix().'__add_thanks_review_message_more_info_link_div').'">&nbsp;</div>';
		// add scripts
		$this->getComponent('add-thanks', KocujIL\Enums\ProjectCategory::BACKEND)->setAddThanksDisplay(\KocujPlLib\V8a\Enums\Project\Components\Backend\AddThanks\Display::YES);
		// set review message with adding thanks to be displayed
		$this->reviewMessageAddThanksDisplay = true;
		// exit
		return $elements;
	}

	/**
	 * Action for scripts
	 *
	 * @access public
	 * @return void
	 */
	public function actionPrintFooterScripts() {
		// initialize review message script
		if ($this->reviewMessageAddThanksDisplay) {
			// get window function
			$jsFunctionName = '';
			$jsFunction = $this->getProjectObj()->getProjectKocujILObj()->get('window', \KocujIL\V8a\Enums\ProjectCategory::ALL)->getWindowJsFunction('add_thanks', $jsFunctionName);
			// show script
			?>
				<script type="text/javascript">
				/* <![CDATA[ */
					<?php echo $jsFunction; ?>
					(function($) {
						$(document).ready(function() {
							kocujPLV8aBackendAddThanks.addProjectIfNotExists('<?php echo esc_js($this->getProjectObj()->getProjectKocujILObj()->getMainSettingInternalName()); ?>', '<?php echo esc_js($jsFunctionName); ?>', '<?php echo esc_js($this->getProjectObj()->getSettingArray('api', 'url')); ?>', '<?php echo esc_js($this->getProjectObj()->getSettingArray('api', 'login')); ?>', '<?php echo esc_js($this->getProjectObj()->getSettingArray('api', 'password')); ?>');
							kocujPLV8aBackendAddThanks.setReviewMessageAddThanks('<?php echo esc_js($this->getProjectObj()->getProjectKocujILObj()->getMainSettingInternalName()); ?>');
						});
					}(jQuery));
				/* ]]> */
				</script>
			<?php
		}
	}
}
