<?php

/**
 * init.class.php
 *
 * @author Dominik Kocuj
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU General Public License v2 or later
 * @copyright Copyright (c) 2016-2017 kocuj.pl
 * @package kocuj_internal_lib
 */

// set namespace
namespace KocujIL\V9a\Classes\Project\Components\Backend\License;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * License (component initialization) class
 *
 * @access public
 */
class Init extends \KocujIL\V9a\Classes\ComponentInitObject {
	/**
	 * Required components
	 *
	 * @access protected
	 * @var array
	 */
	protected $requiredComponents = array(
		'' => array(
			\KocujIL\V9a\Enums\ProjectCategory::ALL => array(
				'window',
			),
		),
	);

	/**
	 * Allow actions and filters in "customizer" (true) or not (false)
	 *
	 * @access protected
	 * @var bool
	 */
	protected $allowActionsAndFiltersInCustomizer = false;

	/**
	 * Constructor
	 *
	 * @access public
	 * @param object $projectObj \KocujIL\V9a\Classes\Project object for current project
	 * @return void
	 */
	public function __construct($projectObj) {
		// execute parent
		parent::__construct($projectObj);
		// set errors
		$this->errors = array(
			\KocujIL\V9a\Enums\Project\Components\Backend\License\ExceptionCode::LICENSE_FILE_DOES_NOT_EXIST => 'License file does not exist',
		);
	}

	/**
	 * Initialize actions and filters
	 *
	 * @access public
	 * @return void
	 */
	public function actionsAndFilters() {
		// add actions for AJAX
		if ((current_user_can('manage_network')) || (current_user_can('manage_options'))) {
			$this->getComponent('actions-filters-helper')->addActionWhenNeeded('wp_ajax_'.$this->getComponent('project-helper')->getPrefix().'__license_display', \KocujIL\V9a\Enums\ProjectCategory::BACKEND, 'license', 'ajax', 'actionAjaxDisplay');
		}
	}
}
