<?php

/**
 * settings-adv-meta-boxes.class.php
 *
 * @author Dominik Kocuj
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU General Public License v2 or later
 * @copyright Copyright (c) 2013-2017 kocuj.pl
 * @package kocuj_sitemap
 */

// set namespace
namespace KocujSitemapPlugin\Classes\KocujPlLibStrings\Backend;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * \KocujPlLib\V9a\Classes\Project\Components\Backend\SettingsAdvMetaBoxes classes strings
 *
 * @access public
 */
class SettingsAdvMetaBoxes implements \KocujIL\V9a\Interfaces\Strings {
	/**
	 * Singleton instance
	 *
	 * @access private
	 * @var object
	 */
	private static $instance = NULL;

	/**
	 * Constructor
	 *
	 * @access private
	 * @return void
	 */
	private function __construct() {
	}

	/**
	 * Disable cloning of object
	 *
	 * @access private
	 * @return void
	 */
	private function __clone() {
	}

	/**
	 * Get singleton instance
	 *
	 * @access public
	 * @return object Singleton instance
	 */
	public static function getInstance() {
		// optionally create new instance
		if (!self::$instance) {
			self::$instance = new self();
		}
		// exit
		return self::$instance;
	}

	/**
	 * Get string
	 *
	 * @access public
	 * @param string $id String id
	 * @return string Output string
	 */
	public function getString($id) {
		// get string
		$texts = array(
			'ACTION_ADMIN_INIT_META_BOX_AUTHOR_PORTFOLIO_WEBSITE_1'    => __('Gardenia Atelier', 'kocuj-sitemap'),
			'ACTION_ADMIN_INIT_META_BOX_AUTHOR_PORTFOLIO_WEBSITE_2'    => __('Star Trek: Horizon', 'kocuj-sitemap'),
			'ACTION_ADMIN_INIT_META_BOX_AUTHOR_PORTFOLIO_WEBSITE_3'    => __('The Light-Life Movement in Krakow province of Capuchins', 'kocuj-sitemap'),
			'ACTION_ADMIN_INIT_META_BOX_AUTHOR_PORTFOLIO_TITLE_PLUGIN' => __('Portfolio fragment of this plugin\'s author', 'kocuj-sitemap'),
			'ACTION_ADMIN_INIT_META_BOX_AUTHOR_PORTFOLIO_TITLE_THEME ' => __('Portfolio fragment of this theme\'s author', 'kocuj-sitemap'),
			'ACTION_ADMIN_INIT_META_BOX_AUTHOR_PORTFOLIO_LANGUAGES'    => __('languages', 'kocuj-sitemap'),
			'ACTION_ADMIN_INIT_META_BOX_AUTHOR_PORTFOLIO_SEE_DEMO'     => __('see demo of the website', 'kocuj-sitemap'),
			'ACTION_ADMIN_INIT_META_BOX_AUTHOR_PORTFOLIO_MORE'         => __('click here to see the entire portfolio', 'kocuj-sitemap'),
			'ACTION_ADMIN_INIT_META_BOX_AUTHOR_TITLE'                  => __('Order your own unique website', 'kocuj-sitemap'),
			/* translators: %s: Link (HTML anchor) to website */
			'ACTION_ADMIN_INIT_META_BOX_AUTHOR_TEXT_1'                 => __('Visit %s website for more information about ordering the website creation.', 'kocuj-sitemap'),
			'ACTION_ADMIN_INIT_META_BOX_AUTHOR_TEXT_2'                 => __('About Dominik Kocuj - the author of this plugin and owner of %s website', 'kocuj-sitemap'),
			'ACTION_ADMIN_INIT_META_BOX_AUTHOR_TEXT_3'                 => __('almost 8 years of working as a websites developer', 'kocuj-sitemap'),
			'ACTION_ADMIN_INIT_META_BOX_AUTHOR_TEXT_4'                 => __('experience of paid employment and self-employed', 'kocuj-sitemap'),
			'ACTION_ADMIN_INIT_META_BOX_AUTHOR_TEXT_5'                 => __('extensive experience in developing plugins and websites in WordPress', 'kocuj-sitemap'),
			'ACTION_ADMIN_INIT_META_BOX_AUTHOR_TEXT_6'                 => __('experience in long-term support of websites, including the online shop and blog based on the WordPress, for the client in UK', 'kocuj-sitemap'),
			'ACTION_ADMIN_INIT_META_BOX_AUTHOR_TEXT_7'                 => __('experience in creating web services for large companies, such as: Polkomtel (Plus GSM), Grand Parade, Betfair, Ladbrokes', 'kocuj-sitemap'),
		);
		// exit
		return (isset($texts[$id])) ?
			$texts[$id] :
			'';
	}
}
