<?php

/**
 * exception-code.class.php
 *
 * @author Dominik Kocuj
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU General Public License v2 or later
 * @copyright Copyright (c) 2016-2017 kocuj.pl
 * @package kocuj_internal_lib
 */

// set namespace
namespace KocujIL\V11a\Enums\Project\Components\All\Widget;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Exceptions codes constants class
 *
 * @access public
 */
final class ExceptionCode {

	/**
	 * Empty constructor for blocking of creating an instance of this class
	 *
	 * @access private
	 * @var void
	 */
	private function __construct() {
	}

	/**
	 * Error: Widget already exists
	 */
	const WIDGET_EXISTS = 1;

	/**
	 * Error: Widget does not exist
	 */
	const WIDGET_DOES_NOT_EXIST = 2;

	/**
	 * Error: Class does not exist
	 */
	const CLASS_DOES_NOT_EXIST = 3;

	/**
	 * Error: Wrong class parent
	 */
	const WRONG_CLASS_PARENT = 4;
}
