<?php

/**
 * exception-code.class.php
 *
 * @author Dominik Kocuj
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU General Public License v2 or later
 * @copyright Copyright (c) 2016-2017 kocuj.pl
 * @package kocuj_internal_lib\kocuj_pl_lib
 */

// set namespace
namespace KocujPlLib\V11a\Enums;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Exceptions codes constants class
 *
 * @access public
 */
final class ExceptionCode {

	/**
	 * Empty constructor for blocking of creating an instance of this class
	 *
	 * @access private
	 * @var void
	 */
	private function __construct() {
	}

	/**
	 * Error: OK
	 */
	const OK = 0;

	/**
	 * Error: Object is not Kocuj Internal Lib project
	 */
	const OBJECT_IS_NOT_KOCUJ_INTERNAL_LIB_PROJECT = 1;

	/**
	 * Error: No required setting data
	 */
	const NO_REQUIRED_SETTING_DATA = 2;
}
