<?php

/**
 * widget.class.php
 *
 * @author Dominik Kocuj
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU General Public License v2 or later
 * @copyright Copyright (c) 2013-2018 kocuj.pl
 * @package kocuj_sitemap
 */

// set namespace
namespace KocujSitemapPlugin\Classes;

// set namespaces aliases
use KocujIL\V12a as KocujIL;

// security
if ((! defined ( 'ABSPATH' )) || ((isset ( $_SERVER ['SCRIPT_FILENAME'] )) && (basename ( $_SERVER ['SCRIPT_FILENAME'] ) === basename ( __FILE__ )))) {
	header ( 'HTTP/1.1 404 Not Found' );
	die ();
}

/**
 * Widget class
 *
 * @access public
 */
class Widget extends KocujIL\Classes\Project\Components\All\Widget\Widget {
	
	/**
	 * Sitemap excludes
	 *
	 * @access private
	 * @var array
	 */
	private $excludes = array ();
	
	/**
	 * Hide types
	 *
	 * @access private
	 * @var array
	 */
	private $hideTypes = array ();
	
	/**
	 * Constructor
	 *
	 * @access public
	 * @return void
	 */
	public function __construct() {
		// execute parent constructor
		/* translators: %s: Name of this plugin ("Kocuj Sitemap") */
		parent::__construct ( 'widget', __ ( 'Sitemap', 'kocuj-sitemap' ), array (
				'global_projectobj' => Base::getInstance ()->getKocujILObj (),
				'global_containerid' => 'widget',
				'global_description' => sprintf ( __ ( 'Sitemap generated by the %s plugin.', 'kocuj-sitemap' ), 'Kocuj Sitemap' ),
				'global_additional' => array (
						'defaulttitle' => __ ( 'Sitemap', 'kocuj-sitemap' ),
						'optiondisplaytitle' => 'display_title',
						'optiontitle' => 'title' 
				) 
		) );
		// add options
		$this->getProjectObj ()->get ( 'options', KocujIL\Enums\ProjectCategory::ALL )->addDefinition ( $this->getContainerId (), 'display', 'text', '', __ ( 'Sitemap type', 'kocuj-sitemap' ) );
		$labels = array ();
		$this->excludes = Sitemap::getInstance ()->getExcludeDefaults ( $labels, '', 'kocujsitemap_widget_default_exclude_' );
		foreach ( $this->excludes as $key => $val ) {
			$this->getProjectObj ()->get ( 'options', KocujIL\Enums\ProjectCategory::ALL )->addDefinition ( $this->getContainerId (), 'exclude_' . $key, 'text', '', __ ( 'Exclude', 'kocuj-sitemap' ) . ' ' . implode ( ', ', ((isset ( $labels [$key] )) ? $labels [$key] : '') ) );
		}
		$this->hideTypes = Sitemap::getInstance ()->getHideTypesList ();
		foreach ( $this->hideTypes as $key => $val ) {
			$this->getProjectObj ()->get ( 'options', KocujIL\Enums\ProjectCategory::ALL )->addDefinition ( $this->getContainerId (), 'hide_type_' . $key, 'checkbox', '0', __ ( 'Hide elements type', 'kocuj-sitemap' ) . ': ' . $val );
		}
	}
	
	/**
	 * Display widget
	 *
	 * @access public
	 * @param array $args
	 *        	Widget arguments
	 * @param array $options
	 *        	Widget options
	 * @return void
	 */
	public function widget($args, $options) {
		// execute parent method
		parent::widget ( $args, $options );
		// prepare widget output
		$exclude = array ();
		foreach ( $this->excludes as $key => $val ) {
			$value = $this->getProjectObj ()->get ( 'options', KocujIL\Enums\ProjectCategory::ALL )->getOption ( $this->getContainerId (), 'exclude_' . $key );
			if (! isset ( $value [0] ) /* strlen($value) === 0 */ ) {
				$value = $val;
			}
			$exclude [$key] = explode ( ',', $value );
		}
		$hideTypes = array ();
		foreach ( $this->hideTypes as $key => $val ) {
			$value = $this->getProjectObj ()->get ( 'options', KocujIL\Enums\ProjectCategory::ALL )->getOption ( $this->getContainerId (), 'hide_type_' . $key );
			if ($value === '1') {
				$hideTypes [] = $key;
			}
		}
		// display widget content
		$display = $this->getProjectObj ()->get ( 'options', KocujIL\Enums\ProjectCategory::ALL )->getOption ( $this->getContainerId (), 'display' );
		switch ($display) {
			case 'dropdown' :
				$displayEnum = \KocujSitemapPlugin\Enums\DisplayType::DROPDOWN;
				break;
			default :
				$displayEnum = \KocujSitemapPlugin\Enums\DisplayType::STANDARD;
		}
		$output = Sitemap::getInstance ()->get ( '', 'kocujsitemapwidget', $exclude, $hideTypes, \KocujSitemapPlugin\Enums\Widget::YES, $displayEnum );
		$this->displayWidgetContent ( $args, $output );
	}
	
	/**
	 * Display widget form
	 *
	 * @access public
	 * @param array $options
	 *        	Widget options
	 * @return void
	 */
	public function form($options) {
		// execute parent method
		parent::form ( $options );
		// add form fields
		$this->getProjectObj ()->get ( 'settings-form', KocujIL\Enums\ProjectCategory::BACKEND )->addOptionFieldToTab ( $this->getContainerId (), $this->getContainerId (), 'select', 'display', __ ( 'Sitemap type to display.', 'kocuj-sitemap' ), array (), array (
				'global_widgetobj' => $this,
				'options' => array (
						'standard' => __ ( 'Standard', 'kocuj-sitemap' ),
						'dropdown' => __ ( 'Dropdown list', 'kocuj-sitemap' ) 
				) 
		) );
		foreach ( $this->excludes as $key => $val ) {
			$this->getProjectObj ()->get ( 'settings-form', KocujIL\Enums\ProjectCategory::BACKEND )->addOptionFieldToTab ( $this->getContainerId (), $this->getContainerId (), 'text', 'exclude_' . $key, __ ( 'Comma separated list of identifiers to exclude in the sitemap.', 'kocuj-sitemap' ), array (), array (
					'global_widgetobj' => $this 
			) );
		}
		foreach ( $this->hideTypes as $key => $val ) {
			$this->getProjectObj ()->get ( 'settings-form', KocujIL\Enums\ProjectCategory::BACKEND )->addOptionFieldToTab ( $this->getContainerId (), $this->getContainerId (), 'checkbox', 'hide_type_' . $key, __ ( 'Hide the selected elements type.', 'kocuj-sitemap' ), array (), array (
					'global_widgetobj' => $this 
			) );
		}
		// show form
		$this->displayForm ();
	}
}
