<?php

/**
 * admin.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html
 * @copyright Copyright (c) 2013 Dominik Kocuj
 * @package kocuj_sitemap
 */

// security
if (basename($_SERVER['SCRIPT_FILENAME']) == basename(__FILE__)) {
	die ('Please do not load this page directly. Thanks!');
}

/**
 * Plugin admin class
 *
 * @access public
 */
class KocujSitemapPluginAdmin extends KocujAdminAdmin1 {
	/**
	 * KocujSitemapPlugin class
	 *
	 * @access private
	 * @var object
	 */
	private $mainClass = null;

	/**
	 * Constructor
	 *
	 * @access public
	 * @param object $mainClass KocujSitemapPlugin class object
	 * @param string $languageDir Directory with language data
	 * @param object $configClass KocujConfigParent1 class object
	 * @return void
	 */
	public function __construct($mainClass, $configClass, $languageDir) {
		// execute parent constructor
		parent::__construct($configClass, $languageDir);
		// save main class
		$this->mainClass = $mainClass;
		// set internal name
		$this->internalName = 'kocuj-sitemap';
		// set minimal full supported version
		$this->minimalFullSupportedVersion = '3.0.0';
		// set title
		$this->title = __('Sitemap', 'kocuj-sitemap');
		// set full title
		$this->fullTitle = 'Kocuj Sitemap';
		// set page name
		$this->addPageName('kocujsitemap');
		$this->addPageName('kocujsitemapuninstall');
		$this->addPageName('kocujsitemapabout');
		// set text domain for translations
		$this->formName = 'kocujsitemapform';
		// set nonce action
		$this->nonceAction = 'kocujsitemap';
		// set license option name
		$this->licenseOption = 'kocujsitemap_license_first';
		// set license URL
		$this->licenseURL = KocujSitemapPlugin::getInstance()->getPluginUrl();
		// set license dir
		$this->licenseDir = KocujSitemapPlugin::getInstance()->getPluginDir();
		// set license name
		$this->licenseName = __('plugin', 'kocuj-sitemap').': Kocuj Sitemap';
		// force license confirmation
		$this->licenseForce = KocujAdminEnumLicensePlace1::NONE;
		// set CSS URL
		$this->cssURL = KocujSitemapPlugin::getInstance()->getPluginUrl().'/css';
		// set JavaScript URL
		$this->javascriptURL = KocujSitemapPlugin::getInstance()->getPluginUrl().'/js';
		// set images URL
		$this->imagesURL = KocujSitemapPlugin::getInstance()->getPluginUrl().'/images';
		// set custom admin icon
		$this->adminIcon = KocujSitemapPlugin::getInstance()->getPluginUrl().'/images/adminicon.png';
		// set custom about image
		$this->aboutImageDir = KocujSitemapPlugin::getInstance()->getPluginDir().'/images/about.png';
		$this->aboutImageURL = KocujSitemapPlugin::getInstance()->getPluginUrl().'/images/about.png';
		// set thanks option name
		$this->thanksOption = 'kocujsitemap_thanks';
		// thanks script API data
		$this->thanksAPILogin = 'kocujsitemapplugin';
		$this->thanksAPIPassword = 'K0cmDi_98XifA';
		// thanks websites
		$this->thanksWebsites[] = 'kocujsitemap.wpplugin.kocuj.pl';
		// add menu
		$this->addSettingsMenu(__('Sitemap', 'kocuj-sitemap'), 'manage_options', 'kocujsitemap', 'pluginSettings', '', KocujSitemapPlugin::getInstance()->getPluginUrl().'/images/icon.png');
		$this->addSettingsMenu(__('Settings', 'kocuj-sitemap'), 'manage_options', 'kocujsitemap', 'pluginSettings', 'kocujsitemap');
		$this->addSettingsMenu(__('Uninstall', 'kocuj-sitemap'), 'manage_options', 'kocujsitemapuninstall', 'pluginUninstall', 'kocujsitemap');
		$this->addSettingsMenu(__('About', 'kocuj-sitemap'), 'manage_options', 'kocujsitemapabout', 'pluginAbout', 'kocujsitemap');
		// check if cache directory is writable
		if (!KocujSitemapPluginCache::getInstance()->checkWritable()) {
			add_action('admin_notices', array(&$this, 'actionCacheDirNotWritableError'));
		}
	}

	/**
	 * Action - information about error with permissions to cache directory
	 *
	 * @access public
	 * @return void
	 */
	public function actionCacheDirNotWritableError() {
		// show error information
		if (current_user_can('manage_options')) {
			echo '<div class="error"><p><strong>'.sprintf(__('Warning! Your cache directory for sitemap in Kocuj Sitemap plugin (placed in "%s") is not writable. Please, change permissions to this directory to allow the plugin to use cache for better performance.', 'kocuj-sitemap'), KocujSitemapPlugin::getInstance()->getPluginDir().'/cache').'</strong></p></div>';
		}
	}

	/**
	 * Save controller
	 *
	 * @access public
	 * @return string Output statuc
	 */
	public function controllerSave() {
		// execute parent method
		$errors = parent::controllerSave();
		// renew cache
		KocujSitemapPluginCache::getInstance()->createCache();
		// exit
		return $errors;
	}

	/**
	 * Reset controller
	 *
	 * @access public
	 * @return string Output statuc
	 */
	public function controllerReset() {
		// execute parent method
		$errors = parent::controllerReset();
		// renew cache
		KocujSitemapPluginCache::getInstance()->createCache();
		// exit
		return '';
	}

	/**
	 * Plugin settings page
	 *
	 * @access public
	 * @return void
	 */
	public function pluginSettings() {
		// declare global
		global $wp_version;
		// register tabs
		$ret = $this->registerTabsContainer('kocujsitemap', $containerId);
		$ret = $this->registerTab($containerId, __('Sitemap format', 'kocuj-sitemap'), $tabSitemapFormatId);
		if (version_compare($wp_version, '3.0.0', '>=')) {
			$ret = $this->registerTab($containerId, __('Menus', 'kocuj-sitemap'), $tabMenusId);
		}
		$ret = $this->registerTab($containerId, __('HTML 5', 'kocuj-sitemap'), $tabHTML5Id);
		// show form
		?>
			<form method="post" action="#" name="<?php echo $this->formName; ?>" id="<?php echo $this->formName; ?>">
				<?php $this->showTabsContainerStart($containerId); ?>
					<?php $this->showTabStart($tabSitemapFormatId); ?>
						<?php $this->showTableStart('sitemap_format'); ?>
							<?php
								$this->blockHelper('LinkToMainSite', 'checkbox', __('If it is checked, the sitemap will display link to the main site as a first entry', 'kocuj-sitemap'));
								if (version_compare($wp_version, '3.0.0', '>=')) {
									$this->blockHelper('DisplayMenus', 'checkbox', __('If it is checked, the sitemap will display menus', 'kocuj-sitemap'));
								}
								$this->blockHelper('DisplayPages', 'checkbox', __('If it is checked, the sitemap will display pages', 'kocuj-sitemap'));
								$this->blockHelper('DisplayPosts', 'checkbox', __('If it is checked, the sitemap will display posts and categories', 'kocuj-sitemap'));
								$options = array();
								if (version_compare($wp_version, '3.0.0', '>=')) {
									$options['MGP'] = __('Menus, pages, posts', 'kocuj-sitemap');
									$options['MPG'] = __('Menus, posts, pages', 'kocuj-sitemap');
									$options['GMP'] = __('Pages, menus, posts', 'kocuj-sitemap');
									$options['PMG'] = __('Posts, menus, pages', 'kocuj-sitemap');
									$options['GPM'] = __('Pages, posts, menus', 'kocuj-sitemap');
									$options['PGM'] = __('Posts, pages, menus', 'kocuj-sitemap');
								} else {
									$options['GP'] = __('Pages, posts', 'kocuj-sitemap');
									$options['PG'] = __('Posts, pages', 'kocuj-sitemap');
								}
								$this->blockHelper('Order', 'select', __('Set order of elements in the sitemap; element which are not available (menus, pages or posts) are not displayed', 'kocuj-sitemap'), $options, '', '', true);
								$this->blockHelper('PoweredBy', 'checkbox', __('Display `powered by` information below sitemap with link to author website; if you find this plugin useful, you are welcome to check this option', 'kocuj-sitemap'));
							?>
						<?php $this->showTableEnd(); ?>
					<?php $this->showTabEnd(); ?>
					<?php if (version_compare($wp_version, '3.0.0', '>=')) : ?>
						<?php $this->showTabStart($tabMenusId); ?>
							<?php $this->showTableStart('menus'); ?>
								<?php
									if (get_terms('nav_menu')) {
										$this->blockHelper('Menus', 'selectmenu', __('Menus which should be included in sitemap; it works only if option `display menus` is checked', 'kocuj-sitemap'));
									} else {
										$this->blockHelper('', 'statictext', __('No menus. Options here will be activated as soon as you create any menu.', 'kocuj-sitemap').$this->getInputHelper('set_Menus[]', 'hidden', '', $this->getConfigClass()->getOptionDefaultValue('Menus')));
									}
								?>
							<?php $this->showTableEnd(); ?>
						<?php $this->showTabEnd(); ?>
					<?php endif; ?>
					<?php $this->showTabStart($tabHTML5Id); ?>
						<?php $this->showTableStart('html5'); ?>
							<?php
								$this->blockHelper('UseHTML5', 'checkbox', __('If it is checked, the sitemap will display itself in HTML 5 navigation tag (`nav`); for Internet Explorer browser version which not supports HTML 5 (all versions below 9), tag will be changed to `div`; this tag will always have CSS class `tagnav` attached to itself', 'kocuj-sitemap'));
							?>
						<?php $this->showTableEnd(); ?>
					<?php $this->showTabEnd(); ?>
				<?php $this->showTabsContainerEnd(); ?>
				<?php $this->showTableStart('submit', false); ?>
					<tr>
						<td colspan="2" class="submit">
							<?php $this->inputHelper('save', 'submit', '', __('Save settings', 'kocuj-sitemap'), '', false, __('Save current settings', 'kocuj-sitemap')); ?>
							<?php $this->inputHelper('reset', 'reset', '', __('Restore default settings', 'kocuj-sitemap'), '', false, __('Reset settings to defaults', 'kocuj-sitemap')); ?>
						</td>
					</tr>
				<?php $this->showTableEnd(); ?>
				<br />
				<input type="hidden" name="action" id="action" value="save" />
			</form>
		<?php
	}

	/**
	 * Plugin uninstall page
	 *
	 * @access public
	 * @return void
	 */
	public function pluginUninstall() {
		// show form
		?>
			<form method="post" action="#" name="<?php echo $this->formName; ?>" id="<?php echo $this->formName; ?>">
			<div class="bordertitle">
				<h3><?php _e('Uninstall', 'kocuj-sitemap') ?></h3>
				<?php $this->showTableStart('uninstall', false); ?>
					<?php
						$this->blockHelper('', 'statictext', '
							'.__('If you want to uninstall this plugin you can disable it in Plugins/Installed menu. After that you can again install this plugin without any setting losses.', 'kocuj-sitemap').'
							<br /><br />
							'.__('If you want permanently delete all plugin settings, click on the button below. Remember that you cannot restore this settings after reinstalling the plugin.', 'kocuj-sitemap').'
						');
						$this->blockHelper('', 'submittext', '
							'.$this->getInputHelper('uninstall', 'uninstall', '', __('Uninstall plugin', 'kocuj-sitemap'), '', false, __('Uninstall plugin settings', 'kocuj-sitemap')).'
						');
					?>
				<?php $this->showTableEnd(); ?>
				<input type="hidden" name="action" id="action" value="uninstall" />
			</div>
			</form>
		<?php
	}

	/**
	 * Plugin about page
	 *
	 * @access public
	 * @return void
	 */
	public function pluginAbout() {
		// show page
		$this->showAboutPage(__('About', 'kocuj-sitemap'), 'Kocuj Sitemap', __('GPL license', 'kocuj-sitemap'),
			'Dominik Kocuj', 'dominik@kocuj.pl', 'http://kocujsitemap.wpplugin.kocuj.pl', sprintf(__('Information about bugs and proposal of a new functionality please send to %s', 'kocuj-sitemap'), '<a href="mailto:dominik@kocuj.pl">dominik@kocuj.pl</a>'));
	}
}

?>