<?php

/**
 * menu.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html
 * @copyright Copyright (c) 2013 Dominik Kocuj
 * @package kocuj_sitemap
 */

// security
if (basename($_SERVER['SCRIPT_FILENAME']) == basename(__FILE__)) {
	die ('Please do not load this page directly. Thanks!');
}

/**
 * Menu sitemap class
 *
 * @access public
 */
if (class_exists('Walker_Nav_Menu')) {
	class KocujSitemapPluginMenu extends Walker_Nav_Menu {
		/**
		 * First
		 *
		 * @access private
		 * @return bool First
		 */
		private $first = false;

		/**
		 * Constructor
		 *
		 * @access public
		 * @param bool $first It is first position in list (true) or not (false)
		 * @return void
		 */
		public function __construct($first) {
			// initialize
			$this->first = $first;
		}

		/**
		 * Get first status
		 *
		 * @access public
		 * @return bool First status
		 */
		public function getFirst() {
			// exit
			return $this->first;
		}

		/**
		 * Start element
		 *
		 * @access public
		 * @param string &$output Output
		 * @param object $item Item
		 * @param int $depth Depth
		 * @param array $args Arguments
		 * @return void
		 */
		public function start_el(&$output, $item, $depth, $args) {
			// get page title
			if ((!isset($item->object_id)) || (empty($item->object_id))) {
				if ((isset($item->post_title)) && (!empty($item->post_title))) {
					if (!isset($item->title)) {
						$item->title = $item->post_title;
					}
				}
				if (!isset($item->url)) {
					$item->url = get_permalink($item->ID);
				}
			}
			if ((isset($item->object_id)) && (!empty($item->object_id))) {
				if ((isset($item->object)) && ($item->object == 'page')) {
					$page = KocujSitemapPluginInternalCacheInterface::getClass()->get_page($item->object_id);
					if (!empty($page)) {
						$item->title = $page->post_title;
						$item->post_title = $page->post_title;
					}
				}
			}
			// prepare menu item
			$objectid = 0;
			if (isset($item->object_id)) {
				$objectid = $item->object_id;
			}
			$indent = ($depth) ? str_repeat("\t", $depth) : '';
			$value = '';
			$classes = empty($item->classes) ? array() : (array)$item->classes;
			$classText = '';
			if (!empty($this->first)) {
				$first_class = apply_filters('kocujsitemap_firstclass', '');
				$add = '';
				if (!empty($first_class)) {
					$add = ' '.$first_class;
				}
				$classText = ' class="kocujsitemapfirst'.$add.'"';
				$this->first = false;
			}
			$output .= $indent.'<li'.$value.$classText.'>';
			$attributes  = !empty($item->attr_title) ? ' title="'.esc_attr($item->attr_title).'"' : '';
			$attributes .= !empty($item->target) ? ' target="'.esc_attr($item->target).'"' : '';
			$attributes .= !empty($item->xfn) ? ' rel="'.esc_attr($item->xfn).'"' : '';
			$attributes .= !empty($item->url) ? ' href="'.esc_attr($item->url).'"' : '';
			$item_output = $args->before;
			$item_output .= '<a'.$attributes.'>';
			$item_output .= $args->link_before.apply_filters('kocujsitemap_linktitle',
				apply_filters('the_title', $item->title, $item->ID)).$args->link_after;
			$item_output .= '</a>';
			$item_output .= $args->after;
			// filter output
			$item_output = apply_filters('kocujsitemap_menuelement', $item_output, $item->object_id);
			// set menu filter
			$output .= apply_filters('walker_nav_menu_start_el', $item_output, $item, $depth, $args);
		}

		/**
		 * End element
		 *
		 * @access public
		 * @param string &$output Output
		 * @param object $item Item
		 * @param int $depth Depth
		 * @return void
		 */
		public function end_el(&$output, $item, $depth) {
			// set output
			$output .= "</li>";
		}

		/**
		 * End element level
		 *
		 * @access public
		 * @param string &$output Output
		 * @param int $depth Depth
		 * @return void
		 */
		public function end_lvl(&$output, $depth) {
			// set output
			if (substr($output, -22) == '<ul class="sub-menu">') {
				$output = substr($output, 0, strlen($output)-23);
			} else {
				$output .= "</ul>";
			}
		}
	}
} else {
	class KocujSitemapPluginMenu {}
}

?>