<?php

/**
 * q-translate-x.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html
 * @copyright Copyright (c) 2013-2016 Dominik Kocuj
 * @package kocuj_sitemap
 */

// set namespace
namespace KocujSitemapPlugin\Classes\MultipleLanguages;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Multiple languages plugin class - qTranslate X
 *
 * @access public
 */
class QTranslateX extends \KocujSitemapPlugin\Classes\MultipleLanguages\QTranslate implements \KocujSitemapPlugin\Interfaces\MultipleLanguages {
	/**
	 * Singleton instance
	 *
	 * @access private
	 * @var object
	 */
	private static $instance = NULL;

	/**
	 * Constructor
	 *
	 * @access private
	 * @return void
	 */
	private function __construct() {
		// change translation plugin functions prefix
		$this->functionsPrefix = 'qtranxf';
	}

	/**
	 * Disable cloning of object
	 *
	 * @access private
	 * @return void
	 */
	private function __clone() {
	}

	/**
	 * Get singleton instance
	 *
	 * @access public
	 * @return object Singleton instance
	 */
	public static function getInstance() {
		// optionally create new instance
		if (!self::$instance) {
			self::$instance = new \KocujSitemapPlugin\Classes\MultipleLanguages\QTranslateX();
		}
		// exit
		return self::$instance;
	}

	/**
	 * Get translation plugin name; it is used in administration panel during the selection of multi-lingual plugin
	 *
	 * @access public
	 * @return string Plugin name
	 */
	public function getName() {
		// get plugin name
		return 'qTranslate X';
	}

	/**
	 * Get plugin priority; it is used to sort translation plugins usage order; the lowest number is the first plugin in order, the highest number is the last plugin in order
	 *
	 * @access public
	 * @return string Plugin priority
	 */
	public function getPriority() {
		// get plugin priority
		return 10;
	}

	/**
	 * Get translation plugin filename with its directory
	 *
	 * @access public
	 * @return string Translation plugin filename
	 */
	public function getPluginFile() {
		// get plugin name
		return 'qtranslate-x/qtranslate.php';
	}
}
