<?php

/**
 * page-about.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html
 * @copyright Copyright (c) 2016 Dominik Kocuj
 * @package kocuj_internal_lib
 */

// set namespace
namespace KocujInternalLib\V1a\Classes\Project\Backend;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Set about page class
 *
 * @access public
 */
class PageAbout extends \KocujInternalLib\V1a\Classes\ProjectObject {
	/**
	 * Data
	 *
	 * @access private
	 * @var array
	 */
	private $data = array();

	/**
	 * Constructor
	 *
	 * @access public
	 * @param object $projectObj \KocujInternalLib\V1a\Classes\Project object for current project
	 * @return void
	 */
	public function __construct($projectObj) {
		// execute parent constructor
		parent::__construct($projectObj);
		// check if it is backend
		if ((!is_admin()) && (!is_network_admin())) {
			return;
		}
	}

	/**
	 * Set page data
	 *
	 * @access public
	 * @param array $data Page data; there are available the following attributes: "additionalinfo1" (string type; first additional information to add to page), "additionalinfo2" (string type; second additional information to add to page), "imagefilename" (string type; filename of image to add at the top of the page)
	 * @return void
	 */
	public function setPageData(array $data) {
		// set page data
		$this->data = array();
		if (isset($data['imagefilename'])) {
			$this->data['imagefilename'] = $data['imagefilename'];
		}
		if (isset($data['additionalinfo1'])) {
			$this->data['additionalinfo1'] = $data['additionalinfo1'];
		}
		if (isset($data['additionalinfo2'])) {
			$this->data['additionalinfo2'] = $data['additionalinfo2'];
		}
	}

	/**
	 * Show page with information about plugin or theme
	 *
	 * @access public
	 * @return void
	 */
	public function showPage() {
		// add action before page
		$this->getProjectObj()->getObj('project-helper')->doAction('before_page_about_div');
		// show begin div
		echo '<div'.$this->getProjectObj()->getObj('project-helper')->applyFiltersForHTMLStyleAndClass('page_about_div').' id="'.$this->getProjectObj()->getObj('project-helper')->getPrefix().'__div_page_about">';
		$this->getProjectObj()->getObj('project-helper')->doAction('before_page_about');
		// optionally show image
		if (isset($this->data['imagefilename'])) {
			// check if file exists
			$filename = $this->getProjectObj()->getObj('dirs')->getCustomImagesDir().'/'.$this->data['imagefilename'];
			if (file_exists($filename)) {
				// show image
				echo \KocujInternalLib\V1a\Classes\Helper::getInstance()->getHTMLImage($this->getProjectObj()->getObj('urls')->getCustomImagesUrl().'/'.$this->data['imagefilename'], array(
					'style' => 'width:100%;height:auto;',
				));
				echo '<br />';
			}
		}
		// show title
		$version = $this->getProjectObj()->getSettingVersion();
		echo '<strong>'.$this->getProjectObj()->getSettingTitleOriginal().((isset($version[0]) /* strlen($version) > 0 */ ) ?
				' v.'.$version :
				''
			).'</strong>';
		echo '<br />';
		// show project URL-s
		$url = $this->getProjectObj()->getSettingUrl();
		if (isset($url[0]) /* strlen($url) > 0 */ ) {
			echo \KocujInternalLib\V1a\Classes\Helper::getInstance()->getLinkAnchor($url, '', array(
				'external' => true,
			));
			echo '<br />';
		}
		// show news channels links
		$linkRSS = $this->getProjectObj()->getSettingNewsChannel('rss');
		$linkFacebook = $this->getProjectObj()->getSettingNewsChannel('facebook');
		$linkTwitter = $this->getProjectObj()->getSettingNewsChannel('twitter');
		if ((isset($linkRSS[0]) /* strlen($linkRSS) > 0 */ ) || (isset($linkFacebook[0]) /* strlen($linkFacebook) > 0 */ ) || (isset($linkTwitter[0]) /* strlen($linkTwitter) > 0 */ )) {
			echo '<br />';
			if (isset($linkRSS[0]) /* strlen($linkRSS) > 0 */ ) {
				echo \KocujInternalLib\V1a\Classes\Helper::getInstance()->getHTMLImage(\KocujInternalLib\V1a\Classes\LibUrls::getInstance()->getImagesUrl().'/icon-rss.png', array(
					'style' => 'float:left;',
				)).'&nbsp;'.\KocujInternalLib\V1a\Classes\Helper::getInstance()->getLinkAnchor($linkRSS, '', array(
					'external' => true,
				));
				echo '<div style="clear:both;"></div>';
			}
			if (isset($linkFacebook[0]) /* strlen($linkFacebook) > 0 */ ) {
				echo \KocujInternalLib\V1a\Classes\Helper::getInstance()->getHTMLImage(\KocujInternalLib\V1a\Classes\LibUrls::getInstance()->getImagesUrl().'/icon-facebook.png', array(
					'style' => 'float:left;',
				)).'&nbsp;'.\KocujInternalLib\V1a\Classes\Helper::getInstance()->getLinkAnchor($linkFacebook, '', array(
					'external' => true,
				));
				echo '<div style="clear:both;"></div>';
			}
			if (isset($linkTwitter[0]) /* strlen($linkTwitter) > 0 */ ) {
				echo \KocujInternalLib\V1a\Classes\Helper::getInstance()->getHTMLImage(\KocujInternalLib\V1a\Classes\LibUrls::getInstance()->getImagesUrl().'/icon-twitter.png', array(
					'style' => 'float:left;',
				)).'&nbsp;'.\KocujInternalLib\V1a\Classes\Helper::getInstance()->getLinkAnchor($linkTwitter, '', array(
					'external' => true,
				));
				echo '<div style="clear:both;"></div>';
			}
		}
		// show empty line
		echo '<br />';
		// show author information
		$author = $this->getProjectObj()->getSettingAuthor('name');
		if (isset($author[0]) /* strlen($author) > 0 */ ) {
			echo $this->getProjectObj()->getStringsObj('backend_page-about')->getString('SHOW_PAGE_AUTHOR').': '.$author;
			$authorUrl = $this->getProjectObj()->getSettingAuthor('url');
			if (isset($authorUrl[0]) /* strlen($authorUrl) > 0 */ ) {
				echo ' ('.\KocujInternalLib\V1a\Classes\Helper::getInstance()->getLinkAnchor($authorUrl, '', array(
					'external' => true,
				)).')';
			}
			$authorEmail = $this->getProjectObj()->getSettingAuthor('email');
			if (isset($authorEmail[0]) /* strlen($authorEmail) > 0 */ ) {
				echo ' &lt;'.\KocujInternalLib\V1a\Classes\Helper::getInstance()->getMailAnchor($authorEmail).'&gt;';
			}
			echo '<br />';
		}
		// show license information
		$licenseName = $this->getProjectObj()->getSettingLicenseName();
		if (isset($licenseName[0]) /* strlen($licenseName) > 0 */ ) {
			echo $this->getProjectObj()->getStringsObj('backend_page-about')->getString('SHOW_PAGE_LICENSE').': '.$this->getProjectObj()->getObj('backend_license')->getLicenseLink();
			echo '<br /><br />';
		}
		// show icons license information
		echo sprintf($this->getProjectObj()->getStringsObj('backend_page-about')->getString('SHOW_PAGE_LICENSE_ICONS'), \KocujInternalLib\V1a\Classes\Helper::getInstance()->getLinkAnchor('http://useiconic.com/open/', '', array(
			'external' => true,
		)), \KocujInternalLib\V1a\Classes\Helper::getInstance()->getLinkAnchor('https://opensource.org/licenses/MIT/', 'MIT', array(
			'external' => true,
		)), \KocujInternalLib\V1a\Classes\Helper::getInstance()->getLinkAnchor('http://wusoftware.pl/', '', array(
			'external' => true,
		)), \KocujInternalLib\V1a\Classes\Helper::getInstance()->getLinkAnchor('http://www.gnu.org/licenses/gpl-2.0.html', 'GPL', array(
			'external' => true,
		)));
		echo '<br /><br />';
		// show first additional information
		if (isset($this->data['additionalinfo1'])) {
			echo $this->data['additionalinfo1'];
			echo '<br /><br />';
		}
		// show second additional information
		if (isset($this->data['additionalinfo2'])) {
			echo $this->data['additionalinfo2'];
			echo '<br /><br />';
		}
		// show support information
		$supportEmail = $this->getProjectObj()->getSettingSupport('email');
		$supportUrl = $this->getProjectObj()->getSettingSupport('url');
		if ((isset($supportEmail[0]) /* strlen($supportEmail) > 0 */ ) || (isset($supportUrl[0]) /* strlen($supportUrl) > 0 */ )) {
			echo '<hr />';
			echo '<br />';
			echo $this->getProjectObj()->getStringsObj('backend_page-about')->getString('SHOW_PAGE_SUPPORT_BUGS_FEATURES').':';
			echo '<br />';
			if (isset($supportEmail[0]) /* strlen($supportEmail) > 0 */ ) {
				echo \KocujInternalLib\V1a\Classes\Helper::getInstance()->getHTMLImage(\KocujInternalLib\V1a\Classes\LibUrls::getInstance()->getImagesUrl().'/support-email.png', array(
					'style' => 'float:left;',
				)).'&nbsp;'.\KocujInternalLib\V1a\Classes\Helper::getInstance()->getMailAnchor($supportEmail);
				echo '<div style="clear:both;"></div>';
			}
			if (isset($supportUrl[0]) /* strlen($supportUrl) > 0 */ ) {
				echo \KocujInternalLib\V1a\Classes\Helper::getInstance()->getHTMLImage(\KocujInternalLib\V1a\Classes\LibUrls::getInstance()->getImagesUrl().'/support-url.png', array(
					'style' => 'float:left;',
				)).'&nbsp;'.\KocujInternalLib\V1a\Classes\Helper::getInstance()->getLinkAnchor($supportUrl, '', array(
					'external' => true,
				));
				echo '<div style="clear:both;"></div>';
			}
			echo '<br />';
		}
		// show information about telling others about this plugin or theme
		$url = $this->getProjectObj()->getSettingUrl();
		if (isset($url[0]) /* strlen($url) > 0 */ ) {
			$tellFacebookUrl = $this->getProjectObj()->getSettingSupportTellOthers('facebook');
			$tellTwitterUrl = $this->getProjectObj()->getSettingSupportTellOthers('twitter');
			if ((isset($tellFacebookUrl[0]) /* strlen($tellFacebookUrl) > 0 */ ) || (isset($tellTwitterUrl[0]) /* strlen($tellTwitterUrl) > 0 */ )) {
				echo '<hr />';
				echo '<br />';
				echo '<strong>';
				if ($this->getProjectObj()->getSettingType() === \KocujInternalLib\V1a\Enums\ProjectType::PLUGIN) {
					echo $this->getProjectObj()->getStringsObj('backend_page-about')->getString('SHOW_PAGE_TELL_OTHERS_PLUGIN');
				}
				if ($this->getProjectObj()->getSettingType() === \KocujInternalLib\V1a\Enums\ProjectType::THEME) {
					echo $this->getProjectObj()->getStringsObj('backend_page-about')->getString('SHOW_PAGE_TELL_OTHERS_THEME');
				}
				echo '</strong>';
				echo '<br />';
				if (isset($tellFacebookUrl[0]) /* strlen($tellFacebookUrl) > 0 */ ) {
					echo \KocujInternalLib\V1a\Classes\Helper::getInstance()->getLinkAnchor($tellFacebookUrl, \KocujInternalLib\V1a\Classes\Helper::getInstance()->getHTMLImage(\KocujInternalLib\V1a\Classes\LibUrls::getInstance()->getImagesUrl().'/icon-facebook.png', array(
						'style' => 'float:left;',
					)), array(
						'external' => true,
					));
				}
				if (isset($tellTwitterUrl[0]) /* strlen($tellTwitterUrl) > 0 */ ) {
					echo \KocujInternalLib\V1a\Classes\Helper::getInstance()->getLinkAnchor($tellTwitterUrl, \KocujInternalLib\V1a\Classes\Helper::getInstance()->getHTMLImage(\KocujInternalLib\V1a\Classes\LibUrls::getInstance()->getImagesUrl().'/icon-twitter.png', array(
						'style' => 'float:left;',
					)), array(
						'external' => true,
					));
				}
				echo '<div style="clear:both;"></div>';
				echo '<br />';
			}
		}
		// show end div
		$this->getProjectObj()->getObj('project-helper')->doAction('after_page_about');
		echo '</div>';
		// add action after page
		$this->getProjectObj()->getObj('project-helper')->doAction('after_page_about_div');
	}
}
