<?php

/**
 * project-helper.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html
 * @copyright Copyright (c) 2016 Dominik Kocuj
 * @package kocuj_internal_lib\kocuj_api_add_thanks_client
 */

// set namespace
namespace KocujApiAddThanksClient\V1a\Classes\Project;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Project helper class
 *
 * @access public
 */
class ProjectHelper extends \KocujInternalLib\V1a\Classes\ProjectObject {
	/**
	 * Get prefix with project internal name for some names in library
	 *
	 * @access public
	 * @return string Prefix
	 */
	public function getPrefix() {
		// exit
		return \KocujApiAddThanksClient\V1a\Classes\Helper::getInstance()->getPrefix().'_'.$this->getProjectObj()->getProjectKocujInternalLibObj()->getSettingInternalName();
	}
}
