// Copyright (c) 2016 Dominik Kocuj <dominik@kocuj.pl>
// License: http://www.gnu.org/licenses/gpl-2.0.html

/* jshint globalstrict: true */

/* global jQuery */
/* global window */

/* global ajaxurl */

/* global kocujInternalLibV1aHelper */
/* global kocujInternalLibV1aModal */

/* global kocujInternalLibV1aBackendVersionCheckSettings */

// version check prototype constructor
function kocujInternalLibV1aClassBackendVersionCheck() {
	'use strict';
	/* jshint validthis: true */
	// get this object
	var self = this;
	// get settings
	if (typeof kocujInternalLibV1aBackendVersionCheckSettings !== 'undefined') {
		if (kocujInternalLibV1aBackendVersionCheckSettings.prefix !== undefined) {
			self._settingsPrefix = kocujInternalLibV1aBackendVersionCheckSettings.prefix;
		}
		if (kocujInternalLibV1aBackendVersionCheckSettings.security !== undefined) {
			self._settingsSecurity = kocujInternalLibV1aBackendVersionCheckSettings.security;
		}
		if (kocujInternalLibV1aBackendVersionCheckSettings.textLoading !== undefined) {
			self._settingsTextLoading = kocujInternalLibV1aBackendVersionCheckSettings.textLoading;
		}
		if (kocujInternalLibV1aBackendVersionCheckSettings.textLoadingError !== undefined) {
			self._settingsTextLoadingError = kocujInternalLibV1aBackendVersionCheckSettings.textLoadingError;
		}
		if (kocujInternalLibV1aBackendVersionCheckSettings.textTitlePlugin !== undefined) {
			self._settingsTextTitlePlugin = kocujInternalLibV1aBackendVersionCheckSettings.textTitlePlugin;
		}
		if (kocujInternalLibV1aBackendVersionCheckSettings.textTitleTheme !== undefined) {
			self._settingsTextTitleTheme = kocujInternalLibV1aBackendVersionCheckSettings.textTitleTheme;
		}
	}
}

// version check prototype
kocujInternalLibV1aClassBackendVersionCheck.prototype = {
	// projects
	_projects : [],
	// settings
	_settingsPrefix : '',
	_settingsSecurity : '',
	_settingsTextLoading : '',
	_settingsTextLoadingError : '',
	_settingsTextTitlePlugin : '',
	_settingsTextTitleTheme : '',

	// add project
	addProject : function(projectId, projectName, projectType, projectVersionFrom, projectVersionTo) {
		'use strict';
		// parse parameters
		projectId = kocujInternalLibV1aHelper.initializeString(projectId);
		if (projectId === '') {
			return;
		}
		projectName = kocujInternalLibV1aHelper.initializeString(projectName);
		// add project
		this._projects['prj_' + projectId] = {
			projectName : projectName,
			projectType : projectType,
			projectVersionFrom : projectVersionFrom,
			projectVersionTo : projectVersionTo
		};
		kocujInternalLibV1aModal.addProject(projectId);
	},

	// get HTML selector for version check header
	getHTMLSelectorVersionCheckHeader : function(projectId) {
		'use strict';
		// exit
		return '#' + this._getHTMLNameVersionCheckHeader(projectId);
	},

	// get HTML selector for version check
	getHTMLSelectorVersionCheck : function(projectId) {
		'use strict';
		// exit
		return '#' + this._getHTMLNameVersionCheck(projectId);
	},

	// show version check window
	showVersionCheck : function(projectId) {
		'use strict';
		// get this object
		var self = this;
		(function($) {
			// parse parameters
			projectId = kocujInternalLibV1aHelper.initializeString(projectId);
			if (projectId === '') {
				return;
			}
			// check if project exists
			if (self._projects['prj_' + projectId] === undefined) {
				return;
			}
			// prepare modal window
			var totalHeight = parseInt($(window).height(), 10)-200;
			if (totalHeight < 140) {
				totalHeight = 140;
			}
			var title = self._settingsTextTitlePlugin;
			if (self._projects['prj_' + projectId].projectType === 'theme') {
				title = self._settingsTextTitleTheme;
			}
			title = title.replace('%1$s', self._projects['prj_' + projectId].projectVersionTo).replace('%2$s', self._projects['prj_' + projectId].projectName);
			kocujInternalLibV1aModal.prepareModal(projectId,
				'<div id="' + self._getHTMLNameVersionCheckHeader(projectId) + '">' +
				title +
				'</div>' +
				'<div id="' + self._getHTMLNameVersionCheck(projectId) + '">' +
				'<em>' +
				self._settingsTextLoading +
				'</em>' +
				'</div>', 600, totalHeight, projectId);
			// set style
			$(self.getHTMLSelectorVersionCheckHeader(projectId)).css({
				'box-sizing': 'content-box',
				'font-size': '13px',
				'text-align': 'center',
				'font-weight': 'normal',
				'line-height': '28px',
				'width': '600px',
				'height': '28px',
				'color': '#cccccc',
				'background-color': '#464646'
			});
			$(self.getHTMLSelectorVersionCheck(projectId)).css({
				'box-sizing': 'content-box',
				'font-size': '12px',
				'text-align': 'left',
				'font-weight': 'normal',
				'width': '580px',
				'height': parseInt(totalHeight-28-20, 10) + 'px',
				'padding': '10px 10px 10px 10px',
				'color': '#464646',
				'background-color': '#ffffff',
				'border-bottom-color': '#000000',
				'border-bottom-style': 'solid',
				'border-bottom-width': '0',
				'overflow': 'auto'
			});
			// show window
			kocujInternalLibV1aModal.showPreparedModal(projectId, '', 1.0);
			// call AJAX
			$.ajax({
				url: ajaxurl,
				async: true,
				cache: false,
				data: {
					action: self._settingsPrefix + '_' + projectId + '__version_check_display',
					security: self._settingsSecurity,
					projectVersionFrom: self._projects['prj_' + projectId].projectVersionFrom,
					projectVersionTo: self._projects['prj_' + projectId].projectVersionTo
				},
				error: function(obj, status, err) {
					self._ajaxError(projectId, obj, status, err);
				},
				success: function(data, status, obj) {
					self._ajaxSuccess(projectId, data, status, obj);
				},
				type: 'POST'
			});
		}(jQuery));
	},

	// get HTML prefix
	_getHTMLPrefix : function(projectId) {
		'use strict';
		// exit
		return this._settingsPrefix + '_' + projectId + '__';
	},

	// get HTML name for version check header
	_getHTMLNameVersionCheckHeader : function(projectId) {
		'use strict';
		// exit
		return this._getHTMLPrefix(projectId) + 'version_check_header';
	},

	// get HTML name for version check
	_getHTMLNameVersionCheck : function(projectId) {
		'use strict';
		// exit
		return this._getHTMLPrefix(projectId) + 'version_check';
	},

	// AJAX loading success
	_ajaxSuccess : function(projectId, data, status, obj) {
		'use strict';
		// get this object
		var self = this;
		(function($) {
			// parse parameters
			projectId = kocujInternalLibV1aHelper.initializeString(projectId);
			// set HTML data
			$(self.getHTMLSelectorVersionCheck(projectId)).html(data);
			// set external links
			$(self.getHTMLSelectorVersionCheck(projectId) + ' a[rel=external]').attr('target', '_blank');
		}(jQuery));
	},

	// AJAX loading error
	_ajaxError : function(projectId, obj, status, err) {
		'use strict';
		// get this object
		var self = this;
		(function($) {
			// parse parameters
			projectId = kocujInternalLibV1aHelper.initializeString(projectId);
			// set HTML data
			$(self.getHTMLSelectorVersionCheck(projectId)).html('<strong>' + self._settingsTextLoadingError + '</strong>');
		}(jQuery));
	}
};

// initialize
var kocujInternalLibV1aBackendVersionCheck = new kocujInternalLibV1aClassBackendVersionCheck();
