<?php

/**
 * add-thanks.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html
 * @copyright Copyright (c) 2016 Dominik Kocuj
 * @package kocuj_internal_lib\kocuj_api_add_thanks_client
 */

// set namespace
namespace KocujApiAddThanksClient\V1a\Classes\Project\Backend;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Adding thanks class
 *
 * @access public
 */
class AddThanks extends \KocujInternalLib\V1a\Classes\ProjectObject {
	/**
	 * Adding thanks is set to be displayed (true) or adding thanks will not be displayed (false)
	 *
	 * @access private
	 * @var bool
	 */
	private $addThanksDisplay = false;

	/**
	 * Constructor
	 *
	 * @access public
	 * @param object $projectObj \KocujApiAddThanksClient\V1a\Classes\Project object for current project
	 * @return void
	 */
	public function __construct($projectObj) {
		// execute parent constructor
		parent::__construct($projectObj);
		// add uninstall action
		add_action($this->getProjectObj()->getProjectKocujInternalLibObj()->getObj('project-helper')->getPrefix().'__plugin_uninstall', array($this, 'actionPluginUninstall'), 1);
		// check use permissions to display adding thanks
		if ((\KocujInternalLib\V1a\Classes\Helper::getInstance()->checkUserIPLocal()) || ((!current_user_can('manage_network_plugins')) && (!current_user_can('activate_plugins')) && (!current_user_can('install_plugins'))) || ($this->getThanksAddedOptionValue())) {
			return;
		}
		// add actions
		add_action('admin_footer', array($this, 'actionAdminFooter'), 1);
		// add "helper.js" script
		\KocujInternalLib\V1a\Classes\JsHelper::getInstance()->addHelperJS();
		// add "modal.js" script
		\KocujInternalLib\V1a\Classes\JsHelper::getInstance()->addModalJS();
	}

	/**
	 * Set adding thanks to display (true) or not (false)
	 *
	 * @access public
	 * @param bool $addThanksDisplay Adding thanks will be displayed (true) or not (false)
	 * @return void
	 */
	public function setAddThanksDisplay($addThanksDisplay) {
		// set value
		$this->addThanksDisplay = $addThanksDisplay;
	}

	/**
	 * Get thanks added option name
	 *
	 * @access public
	 * @return string Thanks added option name
	 */
	public function getThanksAddedOptionName() {
		// exit
		return $this->getProjectObj()->getProjectKocujInternalLibObj()->getSettingInternalName().'__thanks_added';
	}

	/**
	 * Get if thanks has been added (true) or not (false)
	 *
	 * @access public
	 * @return bool Thanks has been added (true) or not (false)
	 */
	public function getThanksAddedOptionValue() {
		// exit
		return (\KocujInternalLib\V1a\Classes\Helper::getInstance()->getOptionForNetworkOrSite($this->getThanksAddedOptionName()) === false) ?
			false :
			true;
	}

	/**
	 * Action for adding JavaScript scripts
	 *
	 * @access public
	 * @return void
	 */
	public function actionAdminFooter() {
		// add scripts
		if ($this->addThanksDisplay) {
			wp_enqueue_script(\KocujApiAddThanksClient\V1a\Classes\Helper::getInstance()->getPrefix().'-backend-add-thanks', \KocujApiAddThanksClient\V1a\Classes\LibUrls::getInstance()->getJavaScriptUrl().'/backend/add-thanks.js', array(
				'jquery',
				\KocujInternalLib\V1a\Classes\Helper::getInstance()->getPrefix().'-helper',
				\KocujInternalLib\V1a\Classes\Helper::getInstance()->getPrefix().'-modal',
			), \KocujApiAddThanksClient\V1a\Classes\Version::getInstance()->getVersion(), true);
			wp_localize_script(\KocujApiAddThanksClient\V1a\Classes\Helper::getInstance()->getPrefix().'-backend-add-thanks', 'kocujApiAddThanksClientV1aBackendAddThanksSettings', array(
				'prefix'                 => \KocujApiAddThanksClient\V1a\Classes\Helper::getInstance()->getPrefix(),
				'prefixKocujInternalLib' => \KocujInternalLib\V1a\Classes\Helper::getInstance()->getPrefix(),
				'security'               => wp_create_nonce(\KocujApiAddThanksClient\V1a\Classes\Helper::getInstance()->getPrefix().'__add_thanks'),
				'useProxy'               => ((\KocujInternalLib\V1a\Classes\Helper::getInstance()->getUrlProtocol() !== 'http') && (ini_get('allow_url_fopen') === '1')) ?
					'1' :
					'0',
				'websiteUrl'             => get_home_url(),
				'websiteTitle'           => get_bloginfo('name', 'display'),
				'websiteDescription'     => get_bloginfo('description', 'display'),
				'textMoreInfoLink'       => $this->getProjectObj()->getStringsObj('backend_add-thanks')->getString('ACTION_ADMIN_FOOTER_SCRIPT_MORE_INFO_LINK'),
				'textWindowTitle'        => $this->getProjectObj()->getStringsObj('backend_add-thanks')->getString('ACTION_ADMIN_FOOTER_SCRIPT_WINDOW_TITLE'),
				'textWindowLoading'      => $this->getProjectObj()->getStringsObj('backend_add-thanks')->getString('ACTION_ADMIN_FOOTER_SCRIPT_WINDOW_LOADING'),
				'textWindowLoadingError' => $this->getProjectObj()->getStringsObj('backend_add-thanks')->getString('ACTION_ADMIN_FOOTER_SCRIPT_WINDOW_LOADING_ERROR'),
				'textSending'            => $this->getProjectObj()->getStringsObj('backend_add-thanks')->getString('ACTION_ADMIN_FOOTER_SCRIPT_SENDING'),
				'textError'              => $this->getProjectObj()->getStringsObj('backend_add-thanks')->getString('ACTION_ADMIN_FOOTER_SCRIPT_ERROR'),
				'textErrorNoRetries'     => $this->getProjectObj()->getStringsObj('backend_add-thanks')->getString('ACTION_ADMIN_FOOTER_SCRIPT_ERROR_NO_RETRIES'),
				'textErrorAlreadyExists' => $this->getProjectObj()->getStringsObj('backend_add-thanks')->getString('ACTION_ADMIN_FOOTER_SCRIPT_ERROR_ALREADY_EXISTS'),
				'textErrorWrongResponse' => $this->getProjectObj()->getStringsObj('backend_add-thanks')->getString('ACTION_ADMIN_FOOTER_SCRIPT_ERROR_WRONG_RESPONSE'),
				'textSuccess'            => $this->getProjectObj()->getStringsObj('backend_add-thanks')->getString('ACTION_ADMIN_FOOTER_SCRIPT_SUCCESS'),
				'imageLoadingUrl'        => \KocujApiAddThanksClient\V1a\Classes\LibUrls::getInstance()->getImagesUrl().'/loading.gif',
			));
		}
	}

	/**
	 * Action for uninstall plugin
	 *
	 * @access public
	 * @return void
	 */
	public function actionPluginUninstall() {
		// remove option
		\KocujInternalLib\V1a\Classes\Helper::getInstance()->deleteOptionForNetworkOrSite($this->getThanksAddedOptionName());
	}
}
