<?php

/**
 * api-add-thanks-client-backend-add-thanks-ajax-strings.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html
 * @copyright Copyright (c) 2013-2016 Dominik Kocuj
 * @package kocuj_sitemap
 */

// set namespace
namespace KocujSitemapPlugin\Classes;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * \KocujApiAddThanksClient\V1a\Classes\Backend\AddThanksAjax class strings
 *
 * @access public
 */
class ApiAddThanksClientBackendAddThanksAjaxStrings implements \KocujInternalLib\V1a\Interfaces\Strings {
	/**
	 * Singleton instance
	 *
	 * @access private
	 * @var object
	 */
	private static $instance = NULL;

	/**
	 * Constructor
	 *
	 * @access private
	 * @return void
	 */
	private function __construct() {
	}

	/**
	 * Disable cloning of object
	 *
	 * @access private
	 * @return void
	 */
	private function __clone() {
	}

	/**
	 * Get singleton instance
	 *
	 * @access public
	 * @return object Singleton instance
	 */
	public static function getInstance() {
		// optionally create new instance
		if (!self::$instance) {
			self::$instance = new \KocujSitemapPlugin\Classes\ApiAddThanksClientBackendAddThanksAjaxStrings();
		}
		// exit
		return self::$instance;
	}

	/**
	 * Get string
	 *
	 * @access public
	 * @param string $id String id
	 * @return string Output string
	 */
	public function getString($id) {
		// get string
		switch ($id) {
			case 'ACTION_AJAX_ADD_THANKS_MORE_INFO_WINDOW_DISPLAY_WEBSITES_AND':
				return __('and', 'kocuj-sitemap');
			case 'ACTION_AJAX_ADD_THANKS_MORE_INFO_WINDOW_DISPLAY_MORE_1':
				/* translators: %s: List of websites (no links) */
				return __('If you want to thanks the author, please allow to send an information about your website address to him. This information will be used only for statistical purposes and for adding public information about your website on the following websites: %s. Please, keep in mind, that this information can be used in future on another websites which will belong to author - but always for statistical and information purposes.', 'kocuj-sitemap');
			case 'ACTION_AJAX_ADD_THANKS_MORE_INFO_WINDOW_DISPLAY_MORE_2':
				return __('Please, support this project by doing this - it is for free, so it is the best way to thanks the author for his contribution.', 'kocuj-sitemap');
			case 'ACTION_AJAX_ADD_THANKS_MORE_INFO_WINDOW_DISPLAY_MORE_3':
				return __('Only the following information about your website will be send to author:', 'kocuj-sitemap');
			case 'ACTION_AJAX_ADD_THANKS_MORE_INFO_WINDOW_DISPLAY_MORE_4':
				return __('website address (URL)', 'kocuj-sitemap');
			case 'ACTION_AJAX_ADD_THANKS_MORE_INFO_WINDOW_DISPLAY_MORE_5':
				return __('website title', 'kocuj-sitemap');
			case 'ACTION_AJAX_ADD_THANKS_MORE_INFO_WINDOW_DISPLAY_MORE_6':
				return __('website description', 'kocuj-sitemap');
			case 'ACTION_AJAX_ADD_THANKS_MORE_INFO_WINDOW_DISPLAY_MORE_7':
				return __('No other information will be send.', 'kocuj-sitemap');
			case 'ACTION_AJAX_ADD_THANKS_MORE_INFO_WINDOW_DISPLAY_MORE_8':
				return __('These information will not be send anywhere else, only to author, and it will be saved in database belonging to author only.', 'kocuj-sitemap');
		}
		// exit
		return '';
	}
}
