<?php

/**
 * lib-urls.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html
 * @copyright Copyright (c) 2016 Dominik Kocuj
 * @package kocuj_internal_lib\kocuj_api_add_thanks_client
 */

// set namespace
namespace KocujApiAddThanksClient\V1a\Classes;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Library URL-s class
 *
 * @access public
 */
final class LibUrls extends \KocujInternalLib\V1a\Classes\LibUrls {
	/**
	 * Singleton instance
	 *
	 * @access private
	 * @var object
	 */
	private static $instance = NULL;

	/**
	 * Constructor
	 *
	 * @access protected
	 * @return void
	 */
	protected function __construct() {
		// set library directories
		$this->dir = realpath(dirname(__FILE__).'/../');
		// execute parent constructor
		parent::__construct();
	}

	/**
	 * Disable cloning of object
	 *
	 * @access private
	 * @return void
	 */
	private function __clone() {
	}

	/**
	 * Get singleton instance
	 *
	 * @access public
	 * @return object Singleton instance
	 */
	public static function getInstance() {
		// optionally create new instance
		if (!self::$instance) {
			self::$instance = new \KocujApiAddThanksClient\V1a\Classes\LibUrls();
		}
		// exit
		return self::$instance;
	}
}
