<?php

/**
 * exception.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html
 * @copyright Copyright (c) 2016 Dominik Kocuj
 * @package kocuj_internal_lib
 */

// set namespace
namespace KocujInternalLib\V1a\Classes;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Exception class
 *
 * @access public
 */
class Exception extends \Exception {
	/**
	 * Errors data
	 *
	 * @access private
	 * @var array
	 */
	private $errors = array();

	/**
	 * Constructor
	 *
	 * @access public
	 * @param int $code Error code
	 * @param string $filename Filename where there was an error; should be set to __FILE__ during throwing an exception
	 * @param int $line Line number where there was an error; should be set to __LINE__ during throwing an exception
	 * @param string $param Optional argument for error message - default: empty
	 * @return void
	 */
	public function __construct($code, $filename, $line, $param = '') {
		// initialize errors
		$this->setErrors();
		// prepare message
		$message = '[file: '.$filename.', line: '.$line.'] ';
		$message .= (isset($this->errors[$code])) ?
			$this->errors[$code] :
			'Unknown error';
		if (isset($param[0]) /* strlen($param) > 0 */ ) {
			$message .= ' ('.$param.')';
		}
		// execute parent constructor
		parent::__construct($message, $code);
	}

	/**
	 * Set errors data
	 *
	 * @access protected
	 * @return void
	 */
	protected function setErrors() {
		// initialize errors
		$this->errors = array(
			\KocujInternalLib\V1a\Classes\ExceptionCode::OK                       => 'OK',
			\KocujInternalLib\V1a\Classes\ExceptionCode::NO_REQUIRED_SETTING_DATA => 'No required setting data',
		);
	}

	/**
	 * Get errors
	 *
	 * @access protected
	 * @return array Errors
	 */
	protected function getErrors() {
		// exit
		return $this->errors;
	}
}
