<?php

/**
 * dirs.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html
 * @copyright Copyright (c) 2016 Dominik Kocuj
 * @package kocuj_internal_lib
 */

// set namespace
namespace KocujInternalLib\V1a\Classes\Project;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Directories class
 *
 * @access public
 */
class Dirs extends \KocujInternalLib\V1a\Classes\ProjectObject {
	/**
	 * Project directory
	 *
	 * @access private
	 * @var string
	 */
	private $projectDir = '';

	/**
	 * License directory
	 *
	 * @access private
	 * @var string
	 */
	private $licenseDir = '';

	/**
	 * Custom images directory
	 *
	 * @access private
	 * @var string
	 */
	private $customImagesDir = '';

	/**
	 * TinyMCE plugins directory
	 *
	 * @access private
	 * @var string
	 */
	private $tinyMcePluginsDir = '';

	/**
	 * TinyMCE plugins languages directory
	 *
	 * @access private
	 * @var string
	 */
	private $tinyMcePluginsLanguagesDir = '';

	/**
	 * Constructor
	 *
	 * @access public
	 * @param object $projectObj \KocujInternalLib\V1a\Classes\Project object for current project
	 * @return void
	 */
	public function __construct($projectObj) {
		// execute parent constructor
		parent::__construct($projectObj);
		// set directories
		$this->projectDir = dirname($this->getProjectObj()->getSettingMainFilename());
		$this->licenseDir = $this->projectDir;
		$this->customImagesDir = $this->projectDir.'/images';
		$this->tinyMcePluginsDir = $this->projectDir.'/js/tiny-mce';
		$this->tinyMcePluginsLanguagesDir = $this->projectDir.'/php/tiny-mce';
	}

	/**
	 * Get project directory
	 *
	 * @access public
	 * @return string Project directory
	 */
	public function getProjectDir() {
		// get project directory
		return $this->projectDir;
	}

	/**
	 * Set license subdirectory inside the project directory
	 *
	 * @access public
	 * @param string $licenseSubDir License subdirectory inside the project directory
	 * @return void
	 */
	public function setLicenseSubDir($licenseSubDir) {
		// set license subdirectory inside the project directory
		$this->licenseDir = $this->projectDir.'/'.$licenseSubDir;
	}

	/**
	 * Get license directory
	 *
	 * @access public
	 * @return string License directory
	 */
	public function getLicenseDir() {
		// get license directory
		return $this->licenseDir;
	}

	/**
	 * Set custom images subdirectory inside the project directory
	 *
	 * @access public
	 * @param string $customImagesDir Custom images subdirectory inside the project directory
	 * @return void
	 */
	public function setCustomImagesSubDir($customImagesSubDir) {
		// set custom images subdirectory inside the project directory
		$this->customImagesDir = $this->projectDir.'/'.$customImagesSubDir;
	}

	/**
	 * Get custom images directory
	 *
	 * @access public
	 * @return string Custom images directory
	 */
	public function getCustomImagesDir() {
		// get custom images directory
		return $this->customImagesDir;
	}

	/**
	 * Set TinyMCE plugins subdirectory inside the project directory
	 *
	 * @access public
	 * @param string $tinyMcePluginsDir TinyMCE plugins subdirectory inside the project directory
	 * @return void
	 */
	public function setTinyMcePluginsSubDir($tinyMcePluginsSubDir) {
		// set TinyMCE plugins subdirectory inside the project directory
		$this->tinyMcePluginsDir = $this->projectDir.'/'.$tinyMcePluginsSubDir;
	}

	/**
	 * Get TinyMCE plugins directory
	 *
	 * @access public
	 * @return string TinyMCE plugins directory
	 */
	public function getTinyMcePluginsDir() {
		// get TinyMCE plugins directory
		return $this->tinyMcePluginsDir;
	}

	/**
	 * Set TinyMCE plugins languages subdirectory inside the project directory
	 *
	 * @access public
	 * @param string $tinyMcePluginsLanguagesDir TinyMCE plugins languages subdirectory inside the project directory
	 * @return void
	 */
	public function setTinyMcePluginsLanguagesSubDir($tinyMcePluginsLanguagesSubDir) {
		// set TinyMCE plugins languages subdirectory inside the project directory
		$this->tinyMcePluginsLanguagesDir = $this->projectDir.'/'.$tinyMcePluginsLanguagesSubDir;
	}

	/**
	 * Get TinyMCE plugins languages directory
	 *
	 * @access public
	 * @return string TinyMCE plugins languages directory
	 */
	public function getTinyMcePluginsLanguagesDir() {
		// get TinyMCE plugins languages directory
		return $this->tinyMcePluginsLanguagesDir;
	}
}
