<?php

/**
 * version-check-ajax.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html
 * @copyright Copyright (c) 2016 Dominik Kocuj
 * @package kocuj_internal_lib
 */

// set namespace
namespace KocujInternalLib\V1a\Classes\Project\Backend;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Set version check AJAX class
 *
 * @access public
 */
class VersionCheckAjax extends \KocujInternalLib\V1a\Classes\ProjectObject {
	/**
	 * Constructor
	 *
	 * @access public
	 * @param object $projectObj \KocujInternalLib\V1a\Classes\Project object for current project
	 * @return void
	 */
	public function __construct($projectObj) {
		// execute parent constructor
		parent::__construct($projectObj);
		// check if it is backend and check permissions
		if (((!is_admin()) && (!is_network_admin())) || ((!current_user_can('manage_network')) && (!current_user_can('manage_options')))) {
			return;
		}
		// add actions
		add_action('wp_ajax_'.$this->getProjectObj()->getObj('project-helper')->getPrefix().'__version_check_display', array($this, 'actionAjaxDisplay'));
	}

	/**
	 * Action for displaying update information
	 *
	 * @access public
	 * @return void
	 */
	public function actionAjaxDisplay() {
		// check AJAX nonce
		check_ajax_referer(\KocujInternalLib\V1a\Classes\Helper::getInstance()->getPrefix().'__version_info', 'security');
		// check versions of project
		if ((!isset($_POST['projectVersionFrom'])) || (!isset($_POST['projectVersionTo']))) {
			wp_die();
		}
		// get information
		$information = $this->getProjectObj()->getObj('backend_version-check')->getInformation($_POST['projectVersionFrom']);
		// show information
		if ($information !== false) {
			echo str_replace('%2$s', $_POST['projectVersionTo'], str_replace('%1$s', $_POST['projectVersionFrom'], $information));
		}
		// remove request for information about update
		\KocujInternalLib\V1a\Classes\Helper::getInstance()->deleteOptionForNetworkOrSite($this->getProjectObj()->getObj('backend_version-check')->getRequestUpdateInfoOptionName());
		// close connection
		wp_die();
	}
}
