// Copyright (c) 2016 Dominik Kocuj <dominik@kocuj.pl>
// License: http://www.gnu.org/licenses/gpl-2.0.html

/* jshint globalstrict: true */

/* global jQuery */
/* global window */

/* global ajaxurl */

/* global kocujInternalLibV1aModal */
/* global kocujInternalLibV1aHelper */

/* global kocujInternalLibV1aBackendLicenseSettings */

// license prototype constructor
function kocujInternalLibV1aClassBackendLicense() {
	'use strict';
	/* jshint validthis: true */
	// get this object
	var self = this;
	// get settings
	if (typeof kocujInternalLibV1aBackendLicenseSettings !== 'undefined') {
		if (kocujInternalLibV1aBackendLicenseSettings.prefix !== undefined) {
			self._settingsPrefix = kocujInternalLibV1aBackendLicenseSettings.prefix;
		}
		if (kocujInternalLibV1aBackendLicenseSettings.security !== undefined) {
			self._settingsSecurity = kocujInternalLibV1aBackendLicenseSettings.security;
		}
		if (kocujInternalLibV1aBackendLicenseSettings.textLoading !== undefined) {
			self._settingsTextLoading = kocujInternalLibV1aBackendLicenseSettings.textLoading;
		}
		if (kocujInternalLibV1aBackendLicenseSettings.textLoadingError !== undefined) {
			self._settingsTextLoadingError = kocujInternalLibV1aBackendLicenseSettings.textLoadingError;
		}
		if (kocujInternalLibV1aBackendLicenseSettings.textLicense !== undefined) {
			self._settingsTextLicense = kocujInternalLibV1aBackendLicenseSettings.textLicense;
		}
		if (kocujInternalLibV1aBackendLicenseSettings.textAccept !== undefined) {
			self._settingsTextAccept = kocujInternalLibV1aBackendLicenseSettings.textAccept;
		}
		if (kocujInternalLibV1aBackendLicenseSettings.textCancel !== undefined) {
			self._settingsTextCancel = kocujInternalLibV1aBackendLicenseSettings.textCancel;
		}
	}
}

// license prototype
kocujInternalLibV1aClassBackendLicense.prototype = {
	// projects
	_projects : [],
	// settings
	_settingsPrefix : '',
	_settingsSecurity : '',
	_settingsTextLoading : '',
	_settingsTextLoadingError : '',
	_settingsTextLicense : '',
	_settingsTextAccept : '',
	_settingsTextCancel : '',

	// add project
	addProject : function(projectId, projectName) {
		'use strict';
		// parse parameters
		projectId = kocujInternalLibV1aHelper.initializeString(projectId);
		if (projectId === '') {
			return;
		}
		projectName = kocujInternalLibV1aHelper.initializeString(projectName);
		// add project
		this._projects['prj_' + projectId] = projectName;
		kocujInternalLibV1aModal.addProject(projectId);
	},

	// get HTML selector for license header
	getHTMLSelectorLicenseHeader : function(projectId) {
		'use strict';
		// exit
		return '#' + this._getHTMLNameLicenseHeader(projectId);
	},

	// get HTML selector for license
	getHTMLSelectorLicense : function(projectId) {
		'use strict';
		// exit
		return '#' + this._getHTMLNameLicense(projectId);
	},

	// get HTML selector for license force accept
	getHTMLSelectorLicenseForceAccept : function(projectId) {
		'use strict';
		// exit
		return '#' + this._getHTMLNameLicenseForceAccept(projectId);
	},

	// get HTML selector for license accept
	getHTMLSelectorLicenseAccept : function(projectId) {
		'use strict';
		// exit
		return this.getHTMLSelectorLicenseForceAccept(projectId) + ' #' + this._getHTMLNameLicenseAccept(projectId);
	},

	// get HTML selector for license cancel
	getHTMLSelectorLicenseCancel : function(projectId) {
		'use strict';
		// exit
		return this.getHTMLSelectorLicenseForceAccept(projectId) + ' #' + this._getHTMLNameLicenseCancel(projectId);
	},

	// show license window
	showLicense : function(projectId, acceptButton) {
		'use strict';
		// get this object
		var self = this;
		(function($) {
			// parse parameters
			projectId = kocujInternalLibV1aHelper.initializeString(projectId);
			if (projectId === '') {
				return;
			}
			acceptButton = kocujInternalLibV1aHelper.initializeBoolean(acceptButton);
			// check if project exists
			if (self._projects['prj_' + projectId] === undefined) {
				return;
			}
			// prepare modal window
			var totalHeight = parseInt($(window).height(), 10)-200;
			if (totalHeight < 140) {
				totalHeight = 140;
			}
			var licenseTextHeader = self._settingsTextLicense;
			if (self._projects['prj_' + projectId] !== '') {
				licenseTextHeader = self._projects['prj_' + projectId];
			}
			kocujInternalLibV1aModal.prepareModal(projectId,
				'<div id="' + self._getHTMLNameLicenseHeader(projectId) + '">' +
				licenseTextHeader +
				'</div>' +
				'<div id="' + self._getHTMLNameLicense(projectId) + '">' +
				'<em>' +
				self._settingsTextLoading +
				'</em>' +
				'</div>' +
				'<div id="' + self._getHTMLNameLicenseForceAccept(projectId) + '">' +
				'</div>', 600, totalHeight, projectId);
			// optionally remove mask event
			if (acceptButton) {
				kocujInternalLibV1aModal.removeCloseEventFromMask(projectId);
			}
			// set style
			var divHeight = totalHeight-28-20,
				borderWidth = 0,
				divButtonHeight = 0;
			if (acceptButton) {
				divButtonHeight = 40;
				divHeight = totalHeight-28-divButtonHeight-20;
				borderWidth = 1;
			}
			$(self.getHTMLSelectorLicenseHeader(projectId)).css({
				'box-sizing': 'content-box',
				'font-size': '13px',
				'text-align': 'center',
				'font-weight': 'normal',
				'line-height': '28px',
				'width': '600px',
				'height': '28px',
				'color': '#cccccc',
				'background-color': '#464646'
			});
			$(self.getHTMLSelectorLicense(projectId)).css({
				'box-sizing': 'content-box',
				'font-family': '"Courier New", Courier, monospace',
				'font-size': '12px',
				'text-align': 'center',
				'font-weight': 'normal',
				'width': '580px',
				'height': divHeight + 'px',
				'padding': '10px 10px 10px 10px',
				'color': '#464646',
				'background-color': '#ffffff',
				'border-bottom-color': '#000000',
				'border-bottom-style': 'solid',
				'border-bottom-width': borderWidth + 'px',
				'overflow': 'auto'
			});
			$(self.getHTMLSelectorLicenseForceAccept(projectId)).css({
				'box-sizing': 'content-box',
				'font-size': '12px',
				'text-align': 'center',
				'vertical-align': 'middle',
				'font-weight': 'normal',
				'width': '600px',
				'height': divButtonHeight + 'px',
				'color': '#21759b',
				'background-color': '#ececec'
			});
			// optionally show button
			if (acceptButton) {
				$(self.getHTMLSelectorLicenseForceAccept(projectId)).html(
					'<strong>' +
					'<a href="#" id="' + self._getHTMLNameLicenseAccept(projectId) + '">' +
					self._settingsTextAccept +
					'</a>' +
					'</strong>' +
					'<br />' +
					'<div id="' + self._getHTMLNameLicenseCancel(projectId) + '">' +
					self._settingsTextCancel +
					'</div>'
				);
				$(self.getHTMLSelectorLicenseAccept(projectId)).hide();
				$(self.getHTMLSelectorLicenseCancel(projectId)).hide();
				kocujInternalLibV1aModal.addCloseEvent(projectId, self.getHTMLSelectorLicenseAccept(projectId));
				$(self.getHTMLSelectorLicenseAccept(projectId)).attr('href', 'javascript:void(0);');
				$(self.getHTMLSelectorLicenseAccept(projectId)).bind('click.license', function(event) {
					event.preventDefault();
					$.ajax({
						url: ajaxurl,
						async: true,
						cache: false,
						data: {
							action: self._settingsPrefix + '_' + projectId + '__license_accept',
							security: self._settingsSecurity
						},
						type: 'POST'
					});
					kocujInternalLibV1aModal.removeCloseEvent(self.getHTMLSelectorLicenseAccept(projectId));
					$(self.getHTMLSelectorLicenseAccept(projectId)).unbind('click.license');
				});
			}
			// show window
			kocujInternalLibV1aModal.showPreparedModal(projectId, '', 1.0);
			// call AJAX
			$.ajax({
				url: ajaxurl,
				async: true,
				cache: false,
				data: {
					action: self._settingsPrefix + '_' + projectId + '__license_display',
					security: self._settingsSecurity
				},
				error: function(obj, status, err) {
					self._ajaxError(projectId, obj, status, err);
				},
				success: function(data, status, obj) {
					self._ajaxSuccess(projectId, data, status, obj);
				},
				type: 'POST'
			});
		}(jQuery));
	},

	// get HTML prefix
	_getHTMLPrefix : function(projectId) {
		'use strict';
		// exit
		return this._settingsPrefix + '_' + projectId + '__';
	},

	// get HTML name for license header
	_getHTMLNameLicenseHeader : function(projectId) {
		'use strict';
		// exit
		return this._getHTMLPrefix(projectId) + 'license_header';
	},

	// get HTML name for license
	_getHTMLNameLicense : function(projectId) {
		'use strict';
		// exit
		return this._getHTMLPrefix(projectId) + 'license';
	},

	// get HTML name for license force accept
	_getHTMLNameLicenseForceAccept : function(projectId) {
		'use strict';
		// exit
		return this._getHTMLPrefix(projectId) + 'license_button';
	},

	// get HTML name for license accept
	_getHTMLNameLicenseAccept : function(projectId) {
		'use strict';
		// exit
		return this._getHTMLPrefix(projectId) + 'license_accept';
	},

	// get HTML name for license cancel
	_getHTMLNameLicenseCancel : function(projectId) {
		'use strict';
		// exit
		return this._getHTMLPrefix(projectId) + 'license_cancel';
	},

	// AJAX loading success
	_ajaxSuccess : function(projectId, data, status, obj) {
		'use strict';
		// get this object
		var self = this;
		(function($) {
			// parse parameters
			projectId = kocujInternalLibV1aHelper.initializeString(projectId);
			// set HTML data
			$(self.getHTMLSelectorLicense(projectId)).html(data);
			// set external links
			$(self.getHTMLSelectorLicense(projectId) + ' a[rel=external]').attr('target', '_blank');
			// show license confirmation
			if ($(self.getHTMLSelectorLicenseAccept(projectId)).length > 0) {
				$(self.getHTMLSelectorLicenseAccept(projectId)).fadeTo('slow', 1.0);
			}
			if ($(self.getHTMLSelectorLicenseCancel(projectId)).length > 0) {
				$(self.getHTMLSelectorLicenseCancel(projectId)).fadeTo('slow', 1.0);
			}
		}(jQuery));
	},

	// AJAX loading error
	_ajaxError : function(projectId, obj, status, err) {
		'use strict';
		// get this object
		var self = this;
		(function($) {
			// parse parameters
			projectId = kocujInternalLibV1aHelper.initializeString(projectId);
			// set HTML data
			$(self.getHTMLSelectorLicense(projectId)).html('<strong>' + self._settingsTextLoadingError + '</strong>');
		}(jQuery));
	}
};

// initialize
var kocujInternalLibV1aBackendLicense = new kocujInternalLibV1aClassBackendLicense();
