// Copyright (c) 2016 Dominik Kocuj <dominik@kocuj.pl>
// License: http://www.gnu.org/licenses/gpl-2.0.html

/* jshint globalstrict: true */

// helper prototype constructor
function kocujInternalLibV1aClassHelper() {
}

// helper prototype
kocujInternalLibV1aClassHelper.prototype = {
	// initialize numeric value
	initializeNumeric : function(value) {
		'use strict';
		// initialize numeric value
		if (value !== undefined) {
			value = parseInt(value, 10);
			if (isNaN(value)) {
				return '';
			}
		} else {
			return '';
		}
		// exit
		return value;
	},

	// initialize numeric float value
	initializeNumericFloat : function(value) {
		'use strict';
		// initialize numeric value
		if (value !== undefined) {
			value = parseFloat(value, 10);
			if (isNaN(value)) {
				return '';
			}
		} else {
			return '';
		}
		// exit
		return value;
	},

	// initialize string value
	initializeString : function(value) {
		'use strict';
		// initialize string value
		if (typeof value !== 'string') {
			if (typeof value === 'number') {
				return value.toString();
			} else {
				return '';
			}
		}
		// exit
		return value;
	},

	// initialize boolean value
	initializeBoolean : function(value) {
		'use strict';
		// initialize boolean value
		if (typeof value !== 'boolean') {
			if (typeof value === 'number') {
				if ((value !== 0) && (value !== 1)) {
					return '';
				}
				if (value === 0) {
					return false;
				}
				return true;
			} else {
				return '';
			}
		}
		// exit
		return value;
	},

	// initialize function value
	initializeFunction : function(value) {
		'use strict';
		// initialize function value
		if (typeof value !== 'function') {
			return false;
		}
		// exit
		return value;
	}
};

// initialize
var kocujInternalLibV1aHelper = new kocujInternalLibV1aClassHelper();

