<?php

/**
 * exception.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html
 * @copyright Copyright (c) 2016 Dominik Kocuj
 * @package kocuj_internal_lib\kocuj_api_add_thanks_client
 */

// set namespace
namespace KocujApiAddThanksClient\V1a\Classes;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Exception class
 *
 * @access public
 */
final class Exception extends \KocujInternalLib\V1a\Classes\Exception {
	/**
	 * Set errors data
	 *
	 * @access protected
	 * @return void
	 */
	protected function setErrors() {
		// initialize errors
		$this->errors = array(
			\KocujApiAddThanksClient\V1a\Classes\ExceptionCode::OK                                       => 'OK',
			\KocujApiAddThanksClient\V1a\Classes\ExceptionCode::OBJECT_IS_NOT_KOCUJ_INTERNAL_LIB_PROJECT => 'Object is not Kocuj Internal Lib project',
		);
	}
}
