<?php

/**
 * js-helper.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html
 * @copyright Copyright (c) 2016 Dominik Kocuj
 * @package kocuj_internal_lib
 */

// set namespace
namespace KocujInternalLib\V1a\Classes;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * JavaScript helper class
 *
 * @access public
 */
final class JsHelper {
	/**
	 * Singleton instance
	 *
	 * @access private
	 * @var object
	 */
	private static $instance = NULL;

	/**
	 * Action for adding scripts has been already executed (true) or not (false)
	 *
	 * @access private
	 * @var bool
	 */
	private $actionExecuted = false;

	/**
	 * Add "helper.js" script in adding scripts action (true) or not (false)
	 *
	 * @access private
	 * @var bool
	 */
	private $addHelperJS = false;

	/**
	 * Add "helper.js" script in footer (true) or in header (false)
	 *
	 * @access private
	 * @var bool
	 */
	private $addHelperJSInFooter = false;

	/**
	 * Script "helper.js" has been added to queue (true) or not (false)
	 *
	 * @access private
	 * @var bool
	 */
	private $addedHelper = false;

	/**
	 * Add "modal.js" script in adding scripts action (true) or not (false)
	 *
	 * @access private
	 * @var bool
	 */
	private $addModalJS = false;

	/**
	 * Add "modal.js" script in footer (true) or in header (false)
	 *
	 * @access private
	 * @var bool
	 */
	private $addModalJSInFooter = false;

	/**
	 * Script "modal.js" has been added to queue (true) or not (false)
	 *
	 * @access private
	 * @var bool
	 */
	private $addedModal = false;

	/**
	 * Constructor
	 *
	 * @access private
	 * @return void
	 */
	private function __construct() {
		// set scripts actions
		if ((is_admin()) || (is_network_admin())) {
			add_action('admin_enqueue_scripts', array($this, 'actionAddScripts'), 1);
		} else {
			add_action('wp_enqueue_scripts', array($this, 'actionAddScripts'), 1);
		}
	}

	/**
	 * Disable cloning of object
	 *
	 * @access private
	 * @return void
	 */
	private function __clone() {
	}

	/**
	 * Get singleton instance
	 *
	 * @access public
	 * @return object Singleton instance
	 */
	public static function getInstance() {
		// optionally create new instance
		if (!self::$instance) {
			self::$instance = new \KocujInternalLib\V1a\Classes\JsHelper();
		}
		// exit
		return self::$instance;
	}

	/**
	 * Add "helper.js" script
	 *
	 * @access public
	 * @param bool $inFooter Show script in footer (true) or in header (false) - default: false
	 * @return void
	 */
	public function addHelperJS($inFooter = false) {
		// add script
		if (!$this->actionExecuted) {
			$this->addHelperJS = true;
			$this->addHelperJSInFooter = $inFooter;
		} else {
			$this->addHelperJSNow($inFooter);
		}
	}

	/**
	 * Add "helper.js" script now
	 *
	 * @access private
	 * @param bool $inFooter Show script in footer (true) or in header (false) - default: false
	 * @return void
	 */
	private function addHelperJSNow($inFooter = false) {
		// add script now
		if (!$this->addedHelper) {
			wp_enqueue_script(\KocujInternalLib\V1a\Classes\Helper::getInstance()->getPrefix().'-helper', \KocujInternalLib\V1a\Classes\LibUrls::getInstance()->getJavaScriptUrl().'/helper.js', array(), \KocujInternalLib\V1a\Classes\Version::getInstance()->getVersion(), $inFooter);
			$this->addedHelper = true;
		}
	}

	/**
	 * Add "modal.js" script
	 *
	 * @access public
	 * @param bool $inFooter Show script in footer (true) or in header (false) - default: false
	 * @return void
	 */
	public function addModalJS($inFooter = false) {
		// add script
		if (!$this->actionExecuted) {
			$this->addModalJS = true;
			$this->addModalJSInFooter = $inFooter;
		} else {
			$this->addModalJSNow($inFooter);
		}
	}

	/**
	 * Add "modal.js" script now
	 *
	 * @access private
	 * @param bool $inFooter Show script in footer (true) or in header (false) - default: false
	 * @return void
	 */
	private function addModalJSNow($inFooter = false) {
		// add script now
		$this->addHelperJSNow(($this->addHelperJS) ?
			$this->addHelperJSInFooter :
			$this->addModalJSInFooter
		);
		if (!$this->addedModal) {
			wp_enqueue_script(\KocujInternalLib\V1a\Classes\Helper::getInstance()->getPrefix().'-modal', \KocujInternalLib\V1a\Classes\LibUrls::getInstance()->getJavaScriptUrl().'/modal.js', array(
				'jquery',
				\KocujInternalLib\V1a\Classes\Helper::getInstance()->getPrefix().'-helper',
			), \KocujInternalLib\V1a\Classes\Version::getInstance()->getVersion(), $inFooter);
			wp_localize_script(\KocujInternalLib\V1a\Classes\Helper::getInstance()->getPrefix().'-modal', 'kocujInternalLibV1aModalSettings', array(
				'prefix' => \KocujInternalLib\V1a\Classes\Helper::getInstance()->getPrefix(),
			));
			$this->addedModal = true;
		}
	}

	/**
	 * Action for adding scripts
	 *
	 * @access public
	 * @return void
	 */
	public function actionAddScripts() {
		// add scripts
		if (($this->addHelperJS) || ($this->addModalJS)) {
			$this->addHelperJSNow(($this->addHelperJS) ?
				$this->addHelperJSInFooter :
				$this->addModalJSInFooter
			);
		}
		if ($this->addModalJS) {
			$this->addModalJSNow($this->addModalJSInFooter);
		}
		// set action as executed
		$this->actionExecuted = true;
	}
}
