<?php

/**
 * license-ajax.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html
 * @copyright Copyright (c) 2016 Dominik Kocuj
 * @package kocuj_internal_lib
 */

// set namespace
namespace KocujInternalLib\V1a\Classes\Project\Backend;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Set license AJAX class
 *
 * @access public
 */
class LicenseAjax extends \KocujInternalLib\V1a\Classes\ProjectObject {
	/**
	 * Constructor
	 *
	 * @access public
	 * @param object $projectObj \KocujInternalLib\V1a\Classes\Project object for current project
	 * @return void
	 */
	public function __construct($projectObj) {
		// execute parent constructor
		parent::__construct($projectObj);
		// check if it is backend and check permissions
		if (((!is_admin()) && (!is_network_admin())) || ((!current_user_can('manage_network')) && (!current_user_can('manage_options')))) {
			return;
		}
		// add actions
		add_action('wp_ajax_'.$this->getProjectObj()->getObj('project-helper')->getPrefix().'__license_display', array($this, 'actionAjaxDisplay'));
		add_action('wp_ajax_'.$this->getProjectObj()->getObj('project-helper')->getPrefix().'__license_accept', array($this, 'actionAjaxAccept'));
	}

	/**
	 * Action for displaying license
	 *
	 * @access public
	 * @return void
	 */
	public function actionAjaxDisplay() {
		// check AJAX nonce
		check_ajax_referer(\KocujInternalLib\V1a\Classes\Helper::getInstance()->getPrefix().'__license', 'security');
		// display license
		$licenseFilename = $this->getProjectObj()->getObj('backend_license')->getLicenseFilename();
		if (isset($licenseFilename[0]) /* strlen($licenseFilename) > 0 */ ) {
			$licenseFilename = $this->getProjectObj()->getObj('dirs')->getLicenseDir().'/'.$licenseFilename;
			if (file_exists($licenseFilename)) {
				$licenseText = file($licenseFilename);
				if (!empty($licenseText)) {
					foreach ($licenseText as $val) {
						$line = trim($val);
						if ((isset($line[1]) /* strlen($line) > 1 */ ) && (substr($line, 0, 2) === '--')) {
							echo '<hr /><br />';
						} else {
							if (((isset($line[6]) /* strlen($line) > 6 */ ) && (substr($line, 0, 7) === 'http://')) || ((isset($line[7]) /* strlen($line) > 7 */ ) && (substr($line, 0, 8) === 'https://'))) {
								echo \KocujInternalLib\V1a\Classes\Helper::getInstance()->getLinkAnchor($line, '', array(
									'external' => true,
								));
								echo '<br />';
							} else {
								if ($line === mb_convert_case($line, MB_CASE_UPPER, 'UTF-8')) {
									echo '<strong>'.$line.'</strong>';
								} else {
									echo $line;
								}
								echo '<br />';
							}
						}
					}
				}
			}
		}
		// close connection
		wp_die();
	}

	/**
	 * Action for accepting license
	 *
	 * @access public
	 * @return void
	 */
	public function actionAjaxAccept() {
		// check AJAX nonce
		check_ajax_referer(\KocujInternalLib\V1a\Classes\Helper::getInstance()->getPrefix().'__license', 'security');
		// accepting license
		if (($this->getProjectObj()->getObj('backend_license')->getLicenseForceAccept()) && (!$this->getProjectObj()->getObj('backend_license')->getLicenseAcceptOptionValue())) {
			\KocujInternalLib\V1a\Classes\Helper::getInstance()->addOrUpdateOptionForNetworkOrSite($this->getProjectObj()->getObj('backend_license')->getLicenseAcceptOptionName(), '1');
		}
		// close connection
		wp_die();
	}
}
