<?php

/**
 * home.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU General Public License v2 or later
 * @copyright Copyright (c) 2013-2016 Dominik Kocuj
 * @package kocuj_sitemap
 */

// set namespace
namespace KocujSitemapPlugin\Classes\ElementType\Backend;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Home type administration panel class
 *
 * @access public
 */
class Home implements \KocujSitemapPlugin\Interfaces\ElementTypeBackend {
	/**
	 * Add link to homepage to sitemap
	 *
	 * @access public
	 * @param string $locale Language locale - default: empty
	 * @return array Output array
	 */
	public function getElementArray($locale = '') {
		// initialize
		\KocujSitemapPlugin\Classes\Sitemap::getInstance()->setHomeLinkTextPos(-1);
		$array = array();
		// add link to homepage to sitemap
		$value = \KocujSitemapPlugin\Classes\Base::getInstance()->getKocujInternalLibObj()->getObj('config')->getOption('LinkToMainSite');
		if ($value) {
			\KocujSitemapPlugin\Classes\MultipleLanguages::getInstance()->beforeGetHomeURL($locale);
			$link = \KocujInternalLib\V2a\Classes\HtmlHelper::getInstance()->getLinkAnchorBegin(\KocujSitemapPlugin\Classes\Helpers\Url::getInstance()->removeProtocolLocal(\KocujSitemapPlugin\Classes\MultipleLanguages::getInstance()->getTranslatedHomeURL(get_home_url(), $locale)));
			$homeLinkTextPos = strlen($link);
			$link .= '</a>';
			$link = apply_filters('kocujsitemap_element', $link, 0, 'home', $locale);
			$homeLinkTextPos = apply_filters('kocujsitemap_element_home_link_text_position', $homeLinkTextPos, $link, $locale);
			$array = array(
				array(
					'tp' => 'home',
					'lk' => $link,
				),
			);
			\KocujSitemapPlugin\Classes\MultipleLanguages::getInstance()->afterGetHomeURL($locale);
			\KocujSitemapPlugin\Classes\Sitemap::getInstance()->setHomeLinkTextPos($homeLinkTextPos);
		}
		// exit
		return $array;
	}

	/**
	 * Get administration page settings
	 *
	 * @access public
	 * @return array Administration page settings
	 */
	public function getAdminPageSettings() {
		// get administration page settings
		return array();
	}

	/**
	 * Get administration page data
	 *
	 * @access public
	 * @return array Administration page data
	 */
	public function getAdminPageData() {
		// get administration page data
		return array();
	}

	/**
	 * Get administration panel order name
	 *
	 * @access public
	 * @return string Administration panel order name
	 */
	public function getAdminOrderName() {
		// get administration panel order name
		return '';
	}

	/**
	 * Get administration cache actions
	 *
	 * @access public
	 * @return array Administration cache actions
	 */
	public function getAdminCacheActions() {
		// get administration cache actions
		return array();
	}

	/**
	 * Get administration cache filters
	 *
	 * @access public
	 * @return array Administration cache filters
	 */
	public function getAdminCacheFilters() {
		// get administration cache filters
		return array(
			'whitelist_options',
		);
	}
}
