<?php

/**
 * ajax.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU General Public License v2 or later
 * @copyright Copyright (c) 2016 Dominik Kocuj
 * @package kocuj_internal_lib
 */

// set namespace
namespace KocujInternalLib\V3a\Classes\Project\Components\Backend\License;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * License AJAX class
 *
 * @access public
 */
class Ajax extends \KocujInternalLib\V3a\Classes\ComponentObject {
	/**
	 * Action for displaying license
	 *
	 * @access public
	 * @return void
	 */
	public function actionAjaxDisplay() {
		// check AJAX nonce
		check_ajax_referer(\KocujInternalLib\V3a\Classes\Helper::getInstance()->getPrefix().'__license', 'security');
		// display license
		$licenseFilename = $this->getProjectObj()->getComponent('backend', 'license')->getLicenseFilename();
		if (isset($licenseFilename[0]) /* strlen($licenseFilename) > 0 */ ) {
			$licenseFilename = $this->getProjectObj()->getComponent('core', 'dirs')->getProjectDir().'/'.$licenseFilename;
			if (is_file($licenseFilename)) {
				$licenseText = file($licenseFilename);
				if (!empty($licenseText)) {
					foreach ($licenseText as $val) {
						$line = trim($val);
						if ((isset($line[1]) /* strlen($line) > 1 */ ) && (substr($line, 0, 2) === '--')) {
							echo '<hr /><br />';
						} else {
							if (((isset($line[6]) /* strlen($line) > 6 */ ) && (substr($line, 0, 7) === 'http://')) || ((isset($line[7]) /* strlen($line) > 7 */ ) && (substr($line, 0, 8) === 'https://'))) {
								echo \KocujInternalLib\V3a\Classes\HtmlHelper::getInstance()->getLinkAnchor($line, '', array(
									'external' => true,
								));
								echo '<br />';
							} else {
								echo ($line === mb_convert_case($line, MB_CASE_UPPER, 'UTF-8')) ?
									'<strong>'.$line.'</strong>' :
									$line;
								echo '<br />';
							}
						}
					}
				}
			}
		}
		// close connection
		wp_die();
	}

	/**
	 * Action for accepting license
	 *
	 * @access public
	 * @return void
	 */
	public function actionAjaxAccept() {
		// check AJAX nonce
		check_ajax_referer(\KocujInternalLib\V3a\Classes\Helper::getInstance()->getPrefix().'__license', 'security');
		// accepting license
		if (($this->getProjectObj()->getComponent('backend', 'license')->getLicenseForceAccept()) && (!$this->getProjectObj()->getComponent('backend', 'license')->getLicenseAcceptOptionValue())) {
			$this->getProjectObj()->getComponent('core', 'meta')->addOrUpdateOption($this->getProjectObj()->getComponent('backend', 'license')->OPTION_NAME_LICENSE_ACCEPT, '1');
		}
		// close connection
		wp_die();
	}
}
