<?php

/**
 * ajax.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU General Public License v2 or later
 * @copyright Copyright (c) 2016 Dominik Kocuj
 * @package kocuj_internal_lib\kocuj_pl_lib
 */

// set namespace
namespace KocujPlLib\V3a\Classes\Project\Components\Backend\AddThanks;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Adding thanks AJAX class
 *
 * @access public
 */
class Ajax extends \KocujInternalLib\V3a\Classes\ComponentObject {
	/**
	 * Action for proxy to Kocuj API
	 *
	 * @access public
	 * @return void
	 */
	public function actionAjaxProxy() {
		// check AJAX nonce
		check_ajax_referer(\KocujPlLib\V3a\Classes\Helper::getInstance()->getPrefix().'__add_thanks', 'security');
		// check if proxy is enabled
		if ((\KocujInternalLib\V3a\Classes\Helper::getInstance()->getUrlProtocol() === 'http') || (ini_get('allow_url_fopen') !== '1')) {
			wp_die();
		}
		// initialize
		$error = false;
		// get content
		$handle = @fopen($this->getProjectObj()->getSettingArray('api', 'url').'?'.
			'callback='.urlencode(\KocujPlLib\V3a\Classes\Helper::getInstance()->getPrefix()).'_callback&'.
			'requestType=parameters&'.
			'responseType=JSON&'.
			'requestMethod=GET&'.
			urlencode('data[PARAMETER_version]').'=1&'.
			urlencode('data[header][login]').'='.urlencode($this->getProjectObj()->getSettingArray('api', 'login')).'&'.
			urlencode('data[header][password]').'='.urlencode($this->getProjectObj()->getSettingArray('api', 'password')).'&'.
			urlencode('data[request][PARAMETER_command]').'=ADD_THANKS&'.
			urlencode('data[request][url]').'='.urlencode(get_home_url()).'&'.
			urlencode('data[request][title]').'='.urlencode(get_bloginfo('name', 'display')).'&'.
			urlencode('data[request][description]').'='.urlencode(get_bloginfo('description', 'display')).'&'.
			'_='.time(), 'r');
		if ($handle) {
			// load content
			$output = '';
			while (!feof($handle)) {
				$buffer = fgets($handle, 4096);
				if ($buffer !== false) {
					$output .= $buffer;
				} else {
					$error = true;
					break;
				}
			}
			if (!fclose($handle)) {
				$error = true;
			}
			// show output
			if (!$error) {
				header('Content-Type: application/json');
				echo $output;
			}
		} else {
			$error = true;
		}
		// handle errors
		if ($error) {
			header('HTTP/1.1 500 Internal Server Error');
		}
		// close connection
		wp_die();
	}

	/**
	 * Action for set that adding thanks has been finished
	 *
	 * @access public
	 * @return void
	 */
	public function actionAjaxFinished() {
		// check AJAX nonce
		check_ajax_referer(\KocujPlLib\V3a\Classes\Helper::getInstance()->getPrefix().'__add_thanks', 'security');
		// set that adding thanks has been finished
		$this->getProjectObj()->getProjectKocujInternalLibObj()->getComponent('core', 'meta')->addOrUpdateOption($this->getProjectObj()->getComponent('backend', 'add-thanks')->OPTION_NAME_THANKS_ADDED, '1');
		// close connection
		wp_die();
	}

	/**
	 * Action for displaying more information about adding thanks in window
	 *
	 * @access public
	 * @return void
	 */
	public function actionAjaxMoreInfoWindowDisplay() {
		// check AJAX nonce
		check_ajax_referer(\KocujPlLib\V3a\Classes\Helper::getInstance()->getPrefix().'__add_thanks', 'security');
		// get list of websites where website address can be displayed
		$websites = array_merge(array(
			\KocujPlLib\V3a\Classes\Helper::getInstance()->getKocujPlUrl(false),
		), $this->getProjectObj()->getSettingArray('additionalwebsites'));
		$websitesString = '';
		$loopCount = count($websites);
		for ($z=0; $z<$loopCount; $z++) {
			if ($z > 0) {
				$websitesString .= (($z < $loopCount-1) ?
					', ' :
					' '.$this->getProjectObj()->getStringsObj('backend', 'add-thanks')->getString('ACTION_AJAX_ADD_THANKS_MORE_INFO_WINDOW_DISPLAY_WEBSITES_AND').' ');
			}
			$websitesString .= '<strong>'.$websites[$z].'</strong>';
		}
		// show more information about adding thanks
		printf($this->getProjectObj()->getStringsObj('backend', 'add-thanks')->getString('ACTION_AJAX_ADD_THANKS_MORE_INFO_WINDOW_DISPLAY_MORE_1'), $websitesString);
		echo '<br /><br />';
		echo $this->getProjectObj()->getStringsObj('backend', 'add-thanks')->getString('ACTION_AJAX_ADD_THANKS_MORE_INFO_WINDOW_DISPLAY_MORE_2');
		echo '<br /><br />';
		echo $this->getProjectObj()->getStringsObj('backend', 'add-thanks')->getString('ACTION_AJAX_ADD_THANKS_MORE_INFO_WINDOW_DISPLAY_MORE_3');
		echo '<ul style="list-style:disc;margin-left:15px;">';
		echo '<li>';
		echo $this->getProjectObj()->getStringsObj('backend', 'add-thanks')->getString('ACTION_AJAX_ADD_THANKS_MORE_INFO_WINDOW_DISPLAY_MORE_4');
		echo '</li><li>';
		echo $this->getProjectObj()->getStringsObj('backend', 'add-thanks')->getString('ACTION_AJAX_ADD_THANKS_MORE_INFO_WINDOW_DISPLAY_MORE_5');
		echo '</li><li>';
		echo $this->getProjectObj()->getStringsObj('backend', 'add-thanks')->getString('ACTION_AJAX_ADD_THANKS_MORE_INFO_WINDOW_DISPLAY_MORE_6');
		echo '</li>';
		echo '</ul>';
		echo $this->getProjectObj()->getStringsObj('backend', 'add-thanks')->getString('ACTION_AJAX_ADD_THANKS_MORE_INFO_WINDOW_DISPLAY_MORE_7');
		echo '<br /><br />';
		echo $this->getProjectObj()->getStringsObj('backend', 'add-thanks')->getString('ACTION_AJAX_ADD_THANKS_MORE_INFO_WINDOW_DISPLAY_MORE_8');
		// close connection
		wp_die();
	}
}
