<?php

/**
 * ajax.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU General Public License v2 or later
 * @copyright Copyright (c) 2016 Dominik Kocuj
 * @package kocuj_internal_lib
 */

// set namespace
namespace KocujInternalLib\V3a\Classes\Project\Components\Backend\ReviewMessage;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Review message AJAX class
 *
 * @access public
 */
class Ajax extends \KocujInternalLib\V3a\Classes\ComponentObject {
	/**
	 * Action for closing review message window
	 *
	 * @access public
	 * @return void
	 */
	public function actionAjaxClose() {
		// check AJAX nonce
		check_ajax_referer(\KocujInternalLib\V3a\Classes\Helper::getInstance()->getPrefix().'__review_message', 'security');
		// save information about closing review message window
		$this->getProjectObj()->getComponent('core', 'meta')->addOrUpdateOption($this->getProjectObj()->getComponent('backend', 'review-message')->OPTION_NAME_REVIEW_MSG_CLOSED, '1');
		// close connection
		wp_die();
	}
}
