<?php

/**
 * admin.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU General Public License v2 or later
 * @copyright Copyright (c) 2013-2016 Dominik Kocuj
 * @package kocuj_sitemap
 */

// set namespace
namespace KocujSitemapPlugin\Classes\KocujInternalLibStrings\All;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * \KocujInternalLib\V3a\Classes\Project\Components\All\Admin classes strings
 *
 * @access public
 */
class Admin implements \KocujInternalLib\V3a\Interfaces\Strings {
	/**
	 * Singleton instance
	 *
	 * @access private
	 * @var object
	 */
	private static $instance = NULL;

	/**
	 * Constructor
	 *
	 * @access private
	 * @return void
	 */
	private function __construct() {
	}

	/**
	 * Disable cloning of object
	 *
	 * @access private
	 * @return void
	 */
	private function __clone() {
	}

	/**
	 * Get singleton instance
	 *
	 * @access public
	 * @return object Singleton instance
	 */
	public static function getInstance() {
		// optionally create new instance
		if (!self::$instance) {
			self::$instance = new self();
		}
		// exit
		return self::$instance;
	}

	/**
	 * Get string
	 *
	 * @access public
	 * @param string $id String id
	 * @return string Output string
	 */
	public function getString($id) {
		// get string
		switch ($id) {
			case 'INIT_SETTINGS_SAVED':
				return __('Settings saved.', 'kocuj-sitemap');
			case 'INIT_DATA_SAVED':
				return __('Data saved.', 'kocuj-sitemap');
			case 'INIT_SETTINGS_RESET':
				return __('Settings reset.', 'kocuj-sitemap');
			case 'INIT_SETTINGS_UNINSTALLED':
				return __('Settings has been uninstalled.', 'kocuj-sitemap');
			case 'INPUT_HELPER_RESET_CONFIRM':
				return __('Are you sure do you want to restore default settings?', 'kocuj-sitemap');
			case 'INPUT_HELPER_UNINSTALL_CONFIRM':
				return __('Are you sure do you want to uninstall settings?', 'kocuj-sitemap');
			case 'GET_BLOCK_HELPER_ADD_NEW_ELEMENT':
				return __('add new element', 'kocuj-sitemap');
			case 'PAGE_CONTROLLER_UNKNOWN_FORM_ERROR':
				return __('Unknown form error.', 'kocuj-sitemap');
			case 'PAGE_CONTROLLER_WRONG_PARAMETERS':
				return __('Wrong parameters.', 'kocuj-sitemap');
			case 'CONTROLLER_SAVE_EXTERNAL_FORM_ERRORS':
				return __('There were some errors in the form.', 'kocuj-sitemap');
			case 'CONTROLLER_SAVE_EXTERNAL_DATA_ERRORS':
				return __('There were some errors during saving data.', 'kocuj-sitemap');
			case 'PROCESS_OUTPUT_ERRORS':
				return __('There were some errors. Options with these problems have not been saved.', 'kocuj-sitemap');
		}
		// exit
		return '';
	}
}
