<?php

/**
 * component.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU General Public License v2 or later
 * @copyright Copyright (c) 2016 Dominik Kocuj
 * @package kocuj_internal_lib
 */

// set namespace
namespace KocujInternalLib\V3a\Classes\Project\Components\Backend\PluginUninstall;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Plugin uninstallation class
 *
 * @access public
 */
class Component extends \KocujInternalLib\V3a\Classes\ComponentObject {
	/**
	 * Constructor; creating an object will automatically uninstall the plugin; it should be executed in file "uninstall.php" in plugin directory
	 *
	 * @access public
	 * @param object $projectObj \KocujInternalLib\V3a\Classes\Project object for current project
	 * @return void
	 */
	public function __construct($projectObj) {
		// execute parent constructor
		parent::__construct($projectObj);
		// check if it is uninstallation of plugin
		if (!defined('WP_UNINSTALL_PLUGIN')) {
			header('HTTP/1.1 404 Not Found');
			die();
		}
		// check if it is plugin
		if ($this->getProjectObj()->getMainSettingType() !== \KocujInternalLib\V3a\Enums\ProjectType::PLUGIN) {
			return;
		}
		// remove administration data from database
		$this->getProjectObj()->getComponent('core', 'project-helper')->doAction('plugin_uninstall');
		$this->getProjectObj()->getComponent('all', 'config')->uninstallOptions();
		if (is_multisite()) {
			global $wpdb;
			$ids = $wpdb->get_col('SELECT blog_id FROM '.$wpdb->blogs);
			if (!empty($ids)) {
				$currentId = get_current_blog_id();
				foreach ($ids as $id) {
					if ($id !== $currentId) {
						switch_to_blog($id);
						$this->getProjectObj()->getComponent('all', 'config')->uninstallOptions(true);
						restore_current_blog();
					}
				}
			}
		}
		// remove meta options
		$this->getProjectObj()->getComponent('core', 'meta')->forceRealClearDataNow();
	}
}
