<?php

/**
 * component.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU General Public License v2 or later
 * @copyright Copyright (c) 2016 Dominik Kocuj
 * @package kocuj_internal_lib
 */

// set namespace
namespace KocujInternalLib\V4a\Classes\Project\Components\All\JsAjax;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Configuration class
 *
 * @access public
 */
class Component extends \KocujInternalLib\V4a\Classes\ComponentObject {
	/**
	 * Add "js-ajax.js" script
	 *
	 * @access public
	 * @return void
	 */
	public function addAjaxJS() {
		// add required scripts
		\KocujInternalLib\V4a\Classes\JsHelper::getInstance()->addExceptionJS(true);
		\KocujInternalLib\V4a\Classes\JsHelper::getInstance()->addHelperJS(true);
		// add script
		$deps = array(
			'jquery',
			\KocujInternalLib\V4a\Classes\Helper::getInstance()->getPrefix().'-helper',
		);
		if (\KocujInternalLib\V4a\Classes\JsHelper::getInstance()->getThrowErrors()) {
			$deps[] = \KocujInternalLib\V4a\Classes\Helper::getInstance()->getPrefix().'-exception';
		}
		\KocujInternalLib\V4a\Classes\JsHelper::getInstance()->addScript(\KocujInternalLib\V4a\Classes\Helper::getInstance()->getPrefix().'-all-js-ajax', \KocujInternalLib\V4a\Classes\LibUrls::getInstance()->getJavaScriptUrl().'/project/components/all/js-ajax', 'js-ajax', $deps, \KocujInternalLib\V4a\Classes\Version::getInstance()->getVersion(), true, true, 'kocujILV4aAllJsAjaxVals', array(
			'prefix'      => \KocujInternalLib\V4a\Classes\Helper::getInstance()->getPrefix(),
			'security'    => wp_create_nonce(\KocujInternalLib\V4a\Classes\Helper::getInstance()->getPrefix().'__js_ajax'),
			'canUseProxy' => (ini_get('allow_url_fopen') === '1') ?
				'1' :
				'0',
			'ajaxUrl'     => network_admin_url('admin-ajax.php'),
		), true);
	}
}
