<?php

/**
 * component.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU General Public License v2 or later
 * @copyright Copyright (c) 2016 Dominik Kocuj
 * @package kocuj_internal_lib
 */

// set namespace
namespace KocujInternalLib\V4a\Classes\Project\Components\Backend\SettingsHelp;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Settings help class
 *
 * @access public
 */
class Component extends \KocujInternalLib\V4a\Classes\ComponentObject {
	/**
	 * Help topics
	 *
	 * @access private
	 * @var array
	 */
	private $helpTopics = array();

	/**
	 * Action for help has been added (true) or not (false)
	 *
	 * @access private
	 * @var bool
	 */
	private $actionAdded = false;

	/**
	 * Add help topic for settings menu
	 *
	 * @access public
	 * @param string $settingsMenuId Settings menu identifier
	 * @param string $id Help data identifier; must be unique
	 * @param string $title Help title
	 * @param string $content Help content
	 * @return void
	 */
	public function addHelpTopic($settingsMenuId, $id, $title, $content) {
		// check if help topic does not exists already and if settings menu exists
		if ((isset($this->helpTopics[$settingsMenuId][$id])) || ($this->getProjectObj()->getComponent('backend', 'settings-menu')->getSettingsMenu($settingsMenuId) === false)) {
			return;
		}
		// optionally create help topics data and action adding help
		if (!isset($this->helpTopics[$settingsMenuId])) {
			$this->helpTopics[$settingsMenuId] = array();
			if (!$this->actionAdded) {
				add_action('admin_enqueue_scripts', array($this, 'actionAddHelp'));
				$this->actionAdded = true;
			}
		}
		// add help topic
		$this->helpTopics[$settingsMenuId][$id] = array(
			'title'   => $title,
			'content' => $content,
		);
	}

	/**
	 * Action for adding help
	 *
	 * @access public
	 * @return void
	 */
	public function actionAddHelp() {
		// get current screen
		$screen = get_current_screen();
		if (empty($screen)) {
			return;
		}
		// get settings menus
		$settingsMenus = $this->getProjectObj()->getComponent('backend', 'settings-menu')->getSettingsMenus();
		// add help topics
		foreach ($settingsMenus as $key => $val) {
			if ($val['pagescreenname'] === $screen->id) {
				if (isset($this->helpTopics[$key])) {
					foreach ($this->helpTopics[$key] as $key2 => $val2) {
						$screen->add_help_tab(array(
							'id'      => $key2,
							'title'   => $val2['title'],
							'content' => '<div style="width:100%;max-height:250px;">'.$val2['content'].'</div>',
						));
					}
				}
				break;
			}
		}
	}
}
