<?php

/**
 * component-object.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU General Public License v2 or later
 * @copyright Copyright (c) 2016 Dominik Kocuj
 * @package kocuj_internal_lib
 */

// set namespace
namespace KocujInternalLib\V4a\Classes;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Component object class
 *
 * @access public
 */
class ComponentObject {
	/**
	 * \KocujInternalLib\V4a\Classes\Project object for current project
	 *
	 * @access private
	 * @var object
	 */
	private $projectObj = NULL;

	/**
	 * Constructor
	 *
	 * @access public
	 * @param object $projectObj \KocujInternalLib\V4a\Classes\Project object for current project
	 * @return void
	 */
	public function __construct($projectObj) {
		// remember project object
		$this->projectObj = $projectObj;
	}

	/**
	 * Get object of type \KocujInternalLib\V4a\Classes\Project
	 *
	 * @access public
	 * @return object Object of type \KocujInternalLib\V4a\Classes\Project
	 */
	public function getProjectObj() {
		// get object of type \KocujInternalLib\V4a\Classes\Project
		return $this->projectObj;
	}

	/**
	 * Get value for class property or constant
	 *
	 * @access public
	 * @param string $key Class property or constant name
	 * @return array|bool|float|int|string Value for class property or constant
	 */
	public function __get($key) {
		// optionally get constant
		$reflection = new \ReflectionObject($this);
		if ($reflection->hasConstant($key)) {
			return $reflection->getConstant($key);
		}
		// exit
		return $this->$key;
	}
}
