<?php

/**
 * posts.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU General Public License v2 or later
 * @copyright Copyright (c) 2013-2016 Dominik Kocuj
 * @package kocuj_sitemap
 */

// set namespace
namespace KocujSitemapPlugin\Classes\ElementType\Backend;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Posts type administration panel class
 *
 * @access public
 */
class Posts implements \KocujSitemapPlugin\Interfaces\ElementTypeBackend {
	/**
	 * Add posts and category by reccurence
	 *
	 * @access private
	 * @param int $parentId Category parent id
	 * @param string $locale Language locale - default: empty
	 * @return array Output array
	 */
	private function addReccurence($parentId, $locale = '') {
		// initialize
		$array = array();
		// check if display categories
		$showCategories = \KocujSitemapPlugin\Classes\Base::getInstance()->getKocujInternalLibObj()->getComponent('all', 'config')->getOption('DisplayPostsCategories');
		// get posts
		if (($parentId !== 0) || (!$showCategories)) {
			$value = \KocujSitemapPlugin\Classes\Base::getInstance()->getKocujInternalLibObj()->getComponent('all', 'config')->getOption('DisplayPostsSort');
			$sortColumn = 'date';
			if (isset($value[0]) /* strlen($value) > 0 */ ) {
				switch ($value) {
					case 'moddate';
						$sortColumn = 'modified';
					break;
					case 'title';
						$sortColumn = 'title';
					break;
					case 'id';
						$sortColumn = 'ID';
					break;
				}
			}
			$value = \KocujSitemapPlugin\Classes\Base::getInstance()->getKocujInternalLibObj()->getComponent('all', 'config')->getOption('DisplayPostsOrder');
			$sortOrder = 'DESC';
			if (isset($value[0]) /* strlen($value) > 0 */ ) {
				switch ($value) {
					case 'asc':
						$sortOrder = 'ASC';
					break;
				}
			}
			\KocujSitemapPlugin\Classes\MultipleLanguages::getInstance()->beforeGetPosts($locale);
			$posts = get_posts(array(
				'category'    => $parentId,
				'orderby'     => $sortColumn,
				'order'       => $sortOrder,
				'post_type'   => 'post',
				'post_status' => 'publish',
				'offset'      => 0,
				'numberposts' => -1,
			));
			\KocujSitemapPlugin\Classes\MultipleLanguages::getInstance()->afterGetPosts($locale);
			if (!empty($posts)) {
				foreach ($posts as $post) {
					\KocujSitemapPlugin\Classes\MultipleLanguages::getInstance()->beforeGetPostItem($post->ID, $locale);
					$linkText = apply_filters('kocujsitemap_linktitle', apply_filters('the_title', \KocujSitemapPlugin\Classes\MultipleLanguages::getInstance()->getTranslatedPostTitle($post->post_title, $post->ID, $locale), $post->ID), $post->ID, 'post', $locale); // for compatibility with 1.x.x
					\KocujSitemapPlugin\Classes\Base::getInstance()->filterOldInfo('kocujsitemap_linktitle', 'kocujsitemap_link_text'); // for compatibility with 1.x.x
					$linkText = apply_filters('kocujsitemap_link_text', $linkText, $post->ID, 'post', $locale);
					if (!isset($linkText[0]) /* strlen($linkText) === 0 */ ) {
						$linkText = '-';
					}
					$link = apply_filters('kocujsitemap_element', \KocujInternalLib\V4a\Classes\HtmlHelper::getInstance()->getLinkAnchor(\KocujSitemapPlugin\Classes\Helpers\Url::getInstance()->removeProtocolLocal(\KocujSitemapPlugin\Classes\MultipleLanguages::getInstance()->getTranslatedPostURL(get_permalink($post->ID), $post->ID, $locale)), $linkText), $post->ID, 'post', $locale);
					$arrayAdd = array(
						'id' => $post->ID,
						'tp' => 'post',
						'lk' => $link,
					);
					if ($sortColumn === 'title') {
						$array[$pos]['sortname'] = $linkText;
					}
					$array[] = $arrayAdd;
					\KocujSitemapPlugin\Classes\MultipleLanguages::getInstance()->afterGetPostItem($post->ID, $locale);
				}
				if ($sortColumn === 'title') {
					$array = \KocujSitemapPlugin\Classes\Helpers\Sort::getInstance()->sortElements($array, $sortOrder);
				}
			}
		}
		// get categories
		if ($showCategories) {
			$showEmptyCategories = \KocujSitemapPlugin\Classes\Base::getInstance()->getKocujInternalLibObj()->getComponent('all', 'config')->getOption('DisplayEmptyPostsCategories');
			\KocujSitemapPlugin\Classes\MultipleLanguages::getInstance()->beforeGetCategories($locale);
			$categories = get_categories(array(
				'type'         => 'post',
				'parent'       => $parentId,
				'orderby'      => 'name',
				'order'        => 'ASC',
				'hide_empty'   => ($showEmptyCategories === '1') ?
					0 :
					1,
				'hierarchical' => 1,
				'taxonomy'     => 'category',
			));
			\KocujSitemapPlugin\Classes\MultipleLanguages::getInstance()->afterGetCategories($locale);
			if (!empty($categories)) {
				$array2 = array();
				foreach ($categories as $category) {
					\KocujSitemapPlugin\Classes\MultipleLanguages::getInstance()->beforeGetCategoryItem($category->cat_ID, $locale);
					$linkText = apply_filters('kocujsitemap_linktitle', \KocujSitemapPlugin\Classes\MultipleLanguages::getInstance()->getTranslatedCategoryTitle($category->name, $category->cat_ID, $locale), $category->cat_ID, 'category', $locale); // for compatibility with 1.x.x
					\KocujSitemapPlugin\Classes\Base::getInstance()->filterOldInfo('kocujsitemap_linktitle', 'kocujsitemap_link_text'); // for compatibility with 1.x.x
					$linkText = apply_filters('kocujsitemap_link_text', $linkText, $category->cat_ID, 'category', $locale);
					if (!isset($linkText[0]) /* strlen($linkText) === 0 */ ) {
						$linkText = '-';
					}
					$link = apply_filters('kocujsitemap_element', \KocujInternalLib\V4a\Classes\HtmlHelper::getInstance()->getLinkAnchor(\KocujSitemapPlugin\Classes\Helpers\Url::getInstance()->removeProtocolLocal(\KocujSitemapPlugin\Classes\MultipleLanguages::getInstance()->getTranslatedCategoryURL(get_category_link($category->cat_ID), $category->cat_ID, $locale)), $linkText), $category->cat_ID, 'category', $locale);
					$pos = count($array2)+count($array);
					$array2[$pos] = array(
						'id'       => $category->cat_ID,
						'tp'       => 'category',
						'lk'       => $link,
						'sortname' => $linkText,
					);
					\KocujSitemapPlugin\Classes\MultipleLanguages::getInstance()->afterGetCategoryItem($category->cat_ID, $locale);
					$array2[$pos]['ch'] = $this->addReccurence($category->cat_ID, $locale);
					if (empty($array2[$pos]['ch'])) {
						unset($array2[$pos]['ch']);
					}
				}
				$array2 = \KocujSitemapPlugin\Classes\Helpers\Sort::getInstance()->sortElements($array2, 'ASC');
				$array = array_merge($array, $array2);
			}
		}
		// exit
		return $array;
	}

	/**
	 * Add posts to sitemap
	 *
	 * @access public
	 * @param string $locale Language locale - default: empty
	 * @return array Output array
	 */
	public function getElementArray($locale = '') {
		// add posts to sitemap
		$value = \KocujSitemapPlugin\Classes\Base::getInstance()->getKocujInternalLibObj()->getComponent('all', 'config')->getOption('DisplayPosts');
		if ($value) {
			return $this->addReccurence(0, $locale);
		}
		// exit
		return array();
	}

	/**
	 * Get administration page settings
	 *
	 * @access public
	 * @return array Administration page settings
	 */
	public function getAdminPageSettings() {
		// get administration page settings
		return array(
			'title' => __('Posts list options', 'kocuj-sitemap'),
			'id'    => 'posts_options',
			'tabs'  => array(
				'posts_displaying' => __('Displaying posts', 'kocuj-sitemap'),
				'posts_options'    => __('Options', 'kocuj-sitemap'),
			),
			'help'  => array(
				'overview' => array(
					'title'   => __('Overview', 'kocuj-sitemap'),
					'content' =>
						__('This is the place where you can enable or disable displaying of posts in the sitemap. Here you can also change how they will be displayed.', 'kocuj-sitemap').'</p>'.
						'<p>'.__('Options are divided into three tabs: `displaying posts`, `options` and `section title`. Each tab can be selected by clicking on it.', 'kocuj-sitemap').'</p>'.
						'<p>'.__('To save changed settings, click on the button `save posts list options`.', 'kocuj-sitemap'),
				),
				'displaying_posts' => array(
					'title'   => __('`Displaying posts` tab', 'kocuj-sitemap'),
					'content' =>
						__('There are the following options in this tab:', 'kocuj-sitemap').'</p>'.
						'<p><ul>'.
						'<li><em>`'.__('Display posts', 'kocuj-sitemap').'`</em>: '.__('If this option is activated, there will be posts list displayed in the sitemap.', 'kocuj-sitemap').'</li>'.
						'</ul>',
				),
				'options' => array(
					'title'   => __('`Options` tab', 'kocuj-sitemap'),
					'content' =>
						__('There are the following options in this tab:', 'kocuj-sitemap').'</p>'.
						'<p><ul>'.
						'<li><em>`'.__('Divide posts into categories', 'kocuj-sitemap').'`</em>: '.__('If this option is activated, posts will be divided into categories.', 'kocuj-sitemap').'</li>'.
						'<li><em>`'.__('Display empty categories', 'kocuj-sitemap').'`</em>: '.__('If this option is activated, empty categories will be displayed.', 'kocuj-sitemap').'</li>'.
						'<li><em>`'.__('Sort posts by', 'kocuj-sitemap').'`</em>: '.__('You can sort posts in the sitemap using the selected posts properties. There are the following posts properties to select:', 'kocuj-sitemap').
						'<ul>'.
						'<li><em>`'.__('created date', 'kocuj-sitemap').'`</em>: '.__('Posts will be sorted by created date.', 'kocuj-sitemap').'</li>'.
						'<li><em>`'.__('last modification date', 'kocuj-sitemap').'`</em>: '.__('Posts will be sorted by last modification date.', 'kocuj-sitemap').'</li>'.
						'<li><em>`'.__('title', 'kocuj-sitemap').'`</em>: '.__('Posts will be sorted by title.', 'kocuj-sitemap').'</li>'.
						'<li><em>`'.__('ID', 'kocuj-sitemap').'`</em>: '.__('Posts will be sorted by post identifier.', 'kocuj-sitemap').'</li>'.
						'</ul>'.
						'</li>'.
						'<li><em>`'.__('Sort posts order', 'kocuj-sitemap').'`</em>: '.__('You can sort posts by ascending or descending order.', 'kocuj-sitemap').'</li>'.
						'</ul>',
				),
				'section_title' => array(
					'title'   => __('`Section title` tab', 'kocuj-sitemap'),
					'content' =>
						__('In this tab you can set the title of the section with posts. It is used if option `divide display into sections` in the main settings of the Kocuj Sitemap plugin is activated.', 'kocuj-sitemap').'</p>'.
						'<p>'.__('There are fields to enter the section title for each language that is available in your WordPress installation. If you have not activated any of the supported plugins for multilingualism, there will be visible only two fields to enter the title - for current WordPress language and for default section title in English language.', 'kocuj-sitemap').'</p>'.
						'<p>'.__('It is not necessary to enter section titles here. However, the place is here in order to be able to display the title of the section in your chosen language if there is no translation for it. If you leave this empty and if you will not have a translation of section title for current language and for default language (English language), there will be displayed the standard section title in English language.', 'kocuj-sitemap'),
				),
			),
		);
	}

	/**
	 * Get administration page data
	 *
	 * @access public
	 * @return array Administration page data
	 */
	public function getAdminPageData() {
		// get administration page data
		$sortArray = array(
			'date'    => __('created date', 'kocuj-sitemap'),
			'moddate' => __('last modification date', 'kocuj-sitemap'),
			'title'   => __('title', 'kocuj-sitemap'),
			'id'      => __('ID', 'kocuj-sitemap'),
		);
		$sortByArray = array(
			'asc'  => __('ascending', 'kocuj-sitemap'),
			'desc' => __('descending', 'kocuj-sitemap'),
		);
		// exit
		return array(
			'pages'   => array(
				\KocujSitemapPlugin\Classes\Base::getInstance()->getKocujInternalLibObj()->getComponent('all', 'admin')->getBlockHelper('DisplayPosts', 'checkbox', __('If this option is activated, there will be posts list displayed in the sitemap.', 'kocuj-sitemap')),
				\KocujSitemapPlugin\Classes\Base::getInstance()->getKocujInternalLibObj()->getComponent('all', 'admin')->getBlockHelper('DisplayPostsCategories', 'checkbox', __('If this option is activated, posts will be divided into categories.', 'kocuj-sitemap')).
					\KocujSitemapPlugin\Classes\Base::getInstance()->getKocujInternalLibObj()->getComponent('all', 'admin')->getBlockHelper('DisplayEmptyPostsCategories', 'checkbox', __('If this option is activated, empty categories will be displayed.', 'kocuj-sitemap')).
					\KocujSitemapPlugin\Classes\Base::getInstance()->getKocujInternalLibObj()->getComponent('all', 'admin')->getBlockHelper('DisplayPostsSort', 'select', __('You can sort posts in the sitemap using the selected posts properties.', 'kocuj-sitemap'), $sortArray).
					\KocujSitemapPlugin\Classes\Base::getInstance()->getKocujInternalLibObj()->getComponent('all', 'admin')->getBlockHelper('DisplayPostsOrder', 'select', __('You can sort posts by ascending or descending order.', 'kocuj-sitemap'), $sortByArray),
			),
			'submit'  => array(
				'title' => __('Save posts list options', 'kocuj-sitemap'),
				'info'  => __('Save current posts list options', 'kocuj-sitemap'),
			),
			'buttons' => '',
		);
	}

	/**
	 * Get administration panel order name
	 *
	 * @access public
	 * @return string Administration panel order name
	 */
	public function getAdminOrderName() {
		// get administration panel order name
		return __('Posts', 'kocuj-sitemap');
	}

	/**
	 * Get administration cache actions
	 *
	 * @access public
	 * @return array Administration cache actions
	 */
	public function getAdminCacheActions() {
		// get administration cache actions
		return array(
			'wp_insert_post',
			'post_updated',
			'after_delete_post',
		);
	}

	/**
	 * Get administration cache filters
	 *
	 * @access public
	 * @return array Administration cache filters
	 */
	public function getAdminCacheFilters() {
		// get administration cache filters
		return array();
	}
}
