<?php

/**
 * init.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU General Public License v2 or later
 * @copyright Copyright (c) 2016 Dominik Kocuj
 * @package kocuj_internal_lib
 */

// set namespace
namespace KocujPlLib\V4a\Classes\Project\Components\Backend\AddThanks;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Adding thanks (component initialization) class
 *
 * @access public
 */
class Init extends \KocujInternalLib\V4a\Classes\ComponentInitObject {
	/**
	 * Required components
	 *
	 * @access protected
	 * @var array
	 */
	protected $requiredComponents = array(
		'KocujInternalLib' => array(
			'all' => array(
				'js-ajax',
			),
		),
	);

	/**
	 * Constructor
	 *
	 * @access public
	 * @param object $projectObj \KocujInternalLib\V4a\Classes\Project object for current project
	 * @return void
	 */
	public function __construct($projectObj) {
		// execute parent
		parent::__construct($projectObj);
		// add uninstall action
		$this->getProjectObj()->getComponent('core', 'actions-filters-helper')->addActionWhenNeeded($this->getProjectObj()->getProjectKocujInternalLibObj()->getComponent('core', 'project-helper')->getPrefix().'__plugin_uninstall', 'backend', 'add-thanks', '', 'actionPluginUninstall', 1);
		// add actions
		if ((!\KocujInternalLib\V4a\Classes\Helper::getInstance()->checkUserIPLocal()) && ((current_user_can('manage_network_plugins')) || (current_user_can('activate_plugins')) || (current_user_can('install_plugins')))) {
			$this->getProjectObj()->getComponent('core', 'actions-filters-helper')->addActionWhenNeeded('admin_footer', 'backend', 'add-thanks', '', 'actionAdminFooter', 1);
		}
		// add actions for AJAX
		if ((!\KocujInternalLib\V4a\Classes\Helper::getInstance()->checkUserIPLocal()) && ((current_user_can('manage_network_plugins')) || (current_user_can('activate_plugins')) || (current_user_can('install_plugins')))) {
			$this->getProjectObj()->getComponent('core', 'actions-filters-helper')->addActionWhenNeeded('wp_ajax_'.$this->getProjectObj()->getComponent('core', 'project-helper')->getPrefix().'__add_thanks_finished', 'backend', 'add-thanks', 'ajax', 'actionAjaxFinished');
			$this->getProjectObj()->getComponent('core', 'actions-filters-helper')->addActionWhenNeeded('wp_ajax_'.$this->getProjectObj()->getComponent('core', 'project-helper')->getPrefix().'__add_thanks_more_info_window_display', 'backend', 'add-thanks', 'ajax', 'actionAjaxMoreInfoWindowDisplay');
		}
	}
}
