<?php

/**
 * component.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU General Public License v2 or later
 * @copyright Copyright (c) 2016 Dominik Kocuj
 * @package kocuj_internal_lib\kocuj_pl_lib
 */

// set namespace
namespace KocujPlLib\V5a\Classes\Project\Components\Backend\PageAboutAddThanks;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Adding thanks from page about class
 *
 * @access public
 */
class Component extends \KocujInternalLib\V5a\Classes\ComponentObject {
	/**
	 * Page about with adding thanks is set to be displayed (true) or page about with adding thanks will not be displayed (false)
	 *
	 * @access private
	 * @var bool
	 */
	private $pageAboutAddThanksDisplay = false;

	/**
	 * Action for displaying adding thanks button in page about
	 *
	 * @access public
	 * @return void
	 */
	public function actionAfterPageAbout() {
		// check if thanks has not been added already
		if ($this->getProjectObj()->getComponent('backend', 'add-thanks')->getThanksAddedOptionValue()) {
			return;
		}
		// show adding thanks
		echo '<div id="'.esc_attr($this->getProjectObj()->getComponent('core', 'project-helper')->getPrefix().'__add_thanks_page_about_div').'">';
		echo '<hr />';
		echo '<br />';
		if ($this->getProjectObj()->getProjectKocujInternalLibObj()->getMainSettingType() === \KocujInternalLib\V5a\Enums\ProjectType::PLUGIN) {
			echo $this->getProjectObj()->getStringsObj('backend', 'page-about-add-thanks')->getString('ACTION_AFTER_PAGE_ABOUT_TEXT_PLUGIN');
		} else {
			echo $this->getProjectObj()->getStringsObj('backend', 'page-about-add-thanks')->getString('ACTION_AFTER_PAGE_ABOUT_TEXT_THEME');
		}
		echo ' ';
		printf($this->getProjectObj()->getStringsObj('backend', 'page-about-add-thanks')->getString('ACTION_AFTER_PAGE_ABOUT_TEXT'), \KocujInternalLib\V5a\Classes\HtmlHelper::getInstance()->getLinkAnchorBegin('#', array(
			'id' => $this->getProjectObj()->getComponent('core', 'project-helper')->getPrefix().'__add_thanks_page_about_more_info_link',
		)), \KocujInternalLib\V5a\Classes\HtmlHelper::getInstance()->getLinkAnchorEnd());
		echo '<br /><br />';
		echo '<input type="button" class="button button-small" id="'.esc_attr($this->getProjectObj()->getComponent('core', 'project-helper')->getPrefix().'__add_thanks_page_about_send').'" value="'.$this->getProjectObj()->getStringsObj('backend', 'page-about-add-thanks')->getString('ACTION_AFTER_PAGE_ABOUT_ADD_THANKS').'" />';
		echo '<br />';
		echo '<div id="'.esc_attr($this->getProjectObj()->getComponent('core', 'project-helper')->getPrefix().'__add_thanks_page_about_status_div').'" style="display:none;">&nbsp;</div>';
		echo '<div id="'.esc_attr($this->getProjectObj()->getComponent('core', 'project-helper')->getPrefix().'__add_thanks_page_about_loading_div').'" style="display:none;">';
		echo \KocujInternalLib\V5a\Classes\HtmlHelper::getInstance()->getHTMLImage(\KocujPlLib\V5a\Classes\LibUrls::getInstance()->getImagesUrl().'/project/components/backend/page-about-add-thanks/loading.gif');
		echo '</div>';
		echo '</div>';
		// add scripts
		$this->getProjectObj()->getComponent('backend', 'add-thanks')->setAddThanksDisplay(true);
		// set page about with adding thanks to be displayed
		$this->pageAboutAddThanksDisplay = true;
	}

	/**
	 * Action for scripts
	 *
	 * @access public
	 * @return void
	 */
	public function actionPrintFooterScripts() {
		// initialize page about script
		if ($this->pageAboutAddThanksDisplay) {
			?>
				<script type="text/javascript">
				/* <![CDATA[ */
					(function($) {
						$(document).ready(function() {
							kocujPLV5aBackendAddThanks.addProjectIfNotExists('<?php echo esc_js($this->getProjectObj()->getProjectKocujInternalLibObj()->getMainSettingInternalName()); ?>', '<?php echo esc_js($this->getProjectObj()->getSettingArray('api', 'url')); ?>', '<?php echo esc_js($this->getProjectObj()->getSettingArray('api', 'login')); ?>', '<?php echo esc_js($this->getProjectObj()->getSettingArray('api', 'password')); ?>');
							kocujPLV5aBackendAddThanks.setPageAboutAddThanks('<?php echo esc_js($this->getProjectObj()->getProjectKocujInternalLibObj()->getMainSettingInternalName()); ?>');
						});
					}(jQuery));
				/* ]]> */
				</script>
			<?php
		}
	}
}
