<?php

/**
 * component.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU General Public License v2 or later
 * @copyright Copyright (c) 2016 Dominik Kocuj
 * @package kocuj_internal_lib
 */

// set namespace
namespace KocujInternalLib\V5a\Classes\Project\Components\Backend\EditorVisualButtons;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Visual editor buttons class
 *
 * @access public
 */
class Component extends \KocujInternalLib\V5a\Classes\ComponentObject {
	/**
	 * Buttons
	 *
	 * @access private
	 * @var array
	 */
	private $buttons = array();

	/**
	 * Add button to text editor
	 *
	 * @access public
	 * @param string $id Button id; must be unique for this project
	 * @param string $filenameJS JavaScript filename
	 * @param string $filenamePHP PHP filename
	 * @return void
	 */
	public function addButton($id, $filenameJS, $filenamePHP = '') {
		// check if button does not exist already
		if (isset($this->buttons[$id])) {
			return;
		}
		// add button
		$this->buttons[$id] = array(
			'filenamejs'  => $filenameJS,
			'filenamephp' => $filenamePHP,
		);
	}

	/**
	 * Filter for TinyMCE plugins
	 *
	 * @access public
	 * @param array $plugins Plugins list
	 * @return array Plugins list
	 */
	public function filterMceExternalPlugins(array $plugins) {
		// filter TinyMCE plugins
		if (!empty($this->buttons)) {
			foreach ($this->buttons as $id => $button) {
				$plugins[$id] = $this->getProjectObj()->getComponent('core', 'urls')->getTinyMceButtonsJSUrl().'/'.$button['filenamejs'];
			}
		}
		// exit
		return $plugins;
	}

	/**
	 * Filter for TinyMCE plugins languages
	 *
	 * @access public
	 * @param array $languages Plugins languages list
	 * @return array Plugins languages list
	 */
	public function filterMceExternalLanguages(array $languages) {
		// filter TinyMCE languages
		if (!empty($this->buttons)) {
			foreach ($this->buttons as $button) {
				$languages[] = $this->getProjectObj()->getComponent('core', 'dirs')->getTinyMceButtonsPHPDir().'/'.$button['filenamephp'];
			}
		}
		// exit
		return $languages;
	}

	/**
	 * Filter for TinyMCE buttons
	 *
	 * @access public
	 * @param array $buttons Buttons list
	 * @return array Buttons list
	 */
	public function filterMceButtons(array $buttons) {
		// filter TinyMCE buttons
		if (!empty($this->buttons)) {
			foreach ($this->buttons as $id => $button) {
				$buttons[] = $id;
			}
		}
		// exit
		return $buttons;
	}
}
