<?php

/**
 * page-about-add-thanks.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU General Public License v2 or later
 * @copyright Copyright (c) 2013-2016 Dominik Kocuj
 * @package kocuj_sitemap
 */

// set namespace
namespace KocujSitemapPlugin\Classes\KocujPlLibStrings\Backend;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * \KocujPlLib\V5a\Classes\Project\Components\Backend\PageAboutAddThanks classes strings
 *
 * @access public
 */
class PageAboutAddThanks implements \KocujInternalLib\V5a\Interfaces\Strings {
	/**
	 * Singleton instance
	 *
	 * @access private
	 * @var object
	 */
	private static $instance = NULL;

	/**
	 * Constructor
	 *
	 * @access private
	 * @return void
	 */
	private function __construct() {
	}

	/**
	 * Disable cloning of object
	 *
	 * @access private
	 * @return void
	 */
	private function __clone() {
	}

	/**
	 * Get singleton instance
	 *
	 * @access public
	 * @return object Singleton instance
	 */
	public static function getInstance() {
		// optionally create new instance
		if (!self::$instance) {
			self::$instance = new self();
		}
		// exit
		return self::$instance;
	}

	/**
	 * Get string
	 *
	 * @access public
	 * @param string $id String id
	 * @return string Output string
	 */
	public function getString($id) {
		// get string
		switch ($id) {
			case 'ACTION_AFTER_PAGE_ABOUT_TEXT_PLUGIN':
				return __('The author of this plugin will be satisfied with the information that you are using this plugin.', 'kocuj-sitemap');
			case 'ACTION_AFTER_PAGE_ABOUT_TEXT_THEME':
				return __('The author of this theme will be satisfied with the information that you are using this theme.', 'kocuj-sitemap');
			case 'ACTION_AFTER_PAGE_ABOUT_TEXT':
				/* translators: 1: begin of HTML anchor ("<a href=..."), 2: end of HTML anchor ("</a>") */
				return __('Please agree to send information about your website address by clicking on the button below. Click %1$shere%2$s to see more information about this procedure.', 'kocuj-sitemap');
			case 'ACTION_AFTER_PAGE_ABOUT_ADD_THANKS':
				return __('Send your website address to author', 'kocuj-sitemap');
		}
		// exit
		return '';
	}
}
