<?php

/**
 * tags.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU General Public License v2 or later
 * @copyright Copyright (c) 2013-2016 Dominik Kocuj
 * @package kocuj_sitemap
 */

// set namespace
namespace KocujSitemapPlugin\Classes\ElementType\Backend;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Tags type administration panel class
 *
 * @access public
 */
class Tags implements \KocujSitemapPlugin\Interfaces\ElementTypeBackend {
	/**
	 * Temporary locale
	 *
	 * @access private
	 * @var string Temporary locale
	 */
	private $localeTemp = '';

	/**
	 * Temporary parameters
	 *
	 * @access private
	 * @var array Temporary parameters
	 */
	private $parsTemp = array();

	/**
	 * Filter for generate tags cloud
	 *
	 * @access public
	 * @param string $data Tags cloud
	 * @param array $tags Tags data
	 * @return string Tags cloud
	 */
	public function filterWPGenerateTagCloud($data, array $tags) {
		// initialize
		$output = array();
		// execute after get tags callback
		\KocujSitemapPlugin\Classes\MultipleLanguages::getInstance()->afterGetTags($this->localeTemp);
		// replace tags
		if (!empty($tags)) {
			// prepare tags index by names
			$tagsIndex = array();
			foreach ($tags as $key => $tag) {
				$tagsIndex[$tag->name] = $key;
			}
			// translate tags in cloud
			$loopCount = count($tags);
			for ($z=0; $z<$loopCount; $z++) {
				// initialize
				$fullLink = $data[$z];
				// get name
				$div = explode('>', $fullLink);
				if (count($div) > 1) {
					$div2 = explode('<', $div[1]);
					if (count($div2) > 0) {
						$name = $div2[0];
						// get tag data by name
						if (isset($tagsIndex[$name])) {
							// initialize
							$additionalClass = array();
							// get tag data
							$id = $tags[$tagsIndex[$name]]->term_id;
							$link = $tags[$tagsIndex[$name]]->link;
							\KocujSitemapPlugin\Classes\MultipleLanguages::getInstance()->beforeGetTagItem($id, $this->localeTemp);
							$div2[0] = apply_filters('kocujsitemap_linktitle', \KocujSitemapPlugin\Classes\MultipleLanguages::getInstance()->getTranslatedTagName($name, $id, $this->localeTemp), $id, 'tag', $this->localeTemp); // for compatibility with 1.x.x
							\KocujSitemapPlugin\Classes\Base::getInstance()->filterOldInfo('kocujsitemap_linktitle', 'kocujsitemap_link_text'); // for compatibility with 1.x.x
							$div2[0] = apply_filters('kocujsitemap_link_text', $div2[0], $id, 'tag', $this->localeTemp);
							$div[1] = implode('<', $div2);
							$fullLink = implode('>', $div);
							unset($div, $div2);
							// translate URL
							$pos = stripos($fullLink, 'href=');
							$containerClassPos = $pos-1;
							if (($pos !== false) && (isset($fullLink[$pos+5]) /* strlen($fullLink) > $pos+5 */ )) {
								$quote = $fullLink[$pos+5];
								$div = explode($quote, $fullLink);
								$pos = array_search($link, $div);
								if (($pos !== false) && ($pos >= 1)) {
									$div[$pos] = esc_url(\KocujSitemapPlugin\Classes\Helpers\Url::getInstance()->removeProtocolLocal(\KocujSitemapPlugin\Classes\MultipleLanguages::getInstance()->getTranslatedTagURL(get_tag_link($id), $id, $this->localeTemp)));
								}
								$oldPos = $pos;
								$pos = array_search(strtolower(' class='), array_map('strtolower', $div));
								if (($pos !== false) && ($pos > $oldPos) && ($pos+1 < count($div))) {
									$additionalClass[] = $div[$pos+1];
									unset($div[$pos], $div[$pos+1]);
								}
								$fullLink = implode($quote, $div);
								unset($div);
							}
							// remember data
							$fullLink = apply_filters('kocujsitemap_element', $fullLink, $id, 'tag', $this->localeTemp);
							$output[] = array(
								'id' => $id,
								'tp' => 'term',
								'lk' => $fullLink,
								'cp' => $containerClassPos,
								'sc' => true,
								'ac' => $additionalClass,
							);
							\KocujSitemapPlugin\Classes\MultipleLanguages::getInstance()->afterGetTagItem($id, $this->localeTemp);
						}
					}
				}
			}
			// sort data
			if ($this->parsTemp['orderby'] === 'name') {
				// get tags data
				$tagsData = $this->getTagsData($this->parsTemp['orderby'], $this->parsTemp['order'], $this->parsTemp['number'], false, $this->localeTemp);
				// sort data
				if (!empty($output)) {
					$tagsTemp = array();
					foreach ($tagsData as $key => $val) {
						foreach ($output as $val2) {
							if ($val['id'] === $val2['id']) {
								$tagsTemp[$key] = $val2;
								break;
							}
						}
					}
					$output = array_values($tagsTemp);
				}
			}
		}
		// exit
		return $output;
	}

	/**
	 * Get tags data
	 *
	 * @access private
	 * @param string $sortColumn Sort column - default: name
	 * @param string $sortOrder Sort order - default: asc
	 * @param int $number Number of tags; 0 means all - default: all
	 * @param bool $onlyUsed Only used tags (true) or not (false) - default: false
	 * @param string $locale Language locale - default: empty
	 * @return array Output array
	 */
	private function getTagsData($sortColumn = 'name', $sortOrder = 'asc', $number = 0, $onlyUsed = false, $locale = '') {
		// initialize
		$output = array();
		// get tags data
		\KocujSitemapPlugin\Classes\MultipleLanguages::getInstance()->beforeGetTags($locale);
		$tags = get_tags(array(
			'orderby'    => $sortColumn,
			'order'      => $sortOrder,
			'hide_empty' => $onlyUsed,
			'number'     => ($number === 0) ?
				'' :
				$number,
			'offset'     => 0,
		));
		\KocujSitemapPlugin\Classes\MultipleLanguages::getInstance()->afterGetTags($locale);
		if (!empty($tags)) {
			foreach ($tags as $tag) {
				\KocujSitemapPlugin\Classes\MultipleLanguages::getInstance()->beforeGetTagItem($tag->term_id, $locale);
				$linkText = apply_filters('kocujsitemap_linktitle', \KocujSitemapPlugin\Classes\MultipleLanguages::getInstance()->getTranslatedTagName($tag->name, $tag->term_id, $locale), $tag->term_id, 'tag', $locale); // for compatibility with 1.x.x
				\KocujSitemapPlugin\Classes\Base::getInstance()->filterOldInfo('kocujsitemap_linktitle', 'kocujsitemap_link_text'); // for compatibility with 1.x.x
				$linkText = apply_filters('kocujsitemap_link_text', $linkText, $tag->term_id, 'tag', $locale);
				if (!isset($linkText[0]) /* strlen($linkText) === 0 */ ) {
					$linkText = '-';
				}
				$link = apply_filters('kocujsitemap_element', \KocujInternalLib\V5a\Classes\HtmlHelper::getInstance()->getLinkAnchor(\KocujSitemapPlugin\Classes\Helpers\Url::getInstance()->removeProtocolLocal(\KocujSitemapPlugin\Classes\MultipleLanguages::getInstance()->getTranslatedTagURL(get_tag_link($tag->term_id), $tag->term_id, $locale)), $linkText), $tag->term_id, 'tag', $locale);
				$outputAdd = array(
					'id' => $tag->term_id,
					'tp' => 'term',
					'lk' => $link,
				);
				if ($sortColumn === 'name') {
					$outputAdd['sortname'] = $linkText;
				}
				$output[] = $outputAdd;
				\KocujSitemapPlugin\Classes\MultipleLanguages::getInstance()->afterGetTagItem($tag->term_id, $locale);
			}
			if ($sortColumn === 'name') {
				$output = \KocujSitemapPlugin\Classes\Helpers\Sort::getInstance()->sortElements($output, $sortOrder);
			}
		}
		// exit
		return $output;
	}

	/**
	 * Add tags to sitemap
	 *
	 * @access public
	 * @param string $locale Language locale - default: empty
	 * @return array Output array
	 */
	public function getElementArray($locale = '') {
		// initialize
		$array = array();
		// add tags to sitemap
		$value = \KocujSitemapPlugin\Classes\Base::getInstance()->getKocujInternalLibObj()->getComponent('all', 'config')->getOption('DisplayTags');
		if ($value) {
			// get tags
			$value = \KocujSitemapPlugin\Classes\Base::getInstance()->getKocujInternalLibObj()->getComponent('all', 'config')->getOption('DisplayTagsSort');
			$sortColumn = 'name';
			if ((isset($value[0]) /* strlen($value) > 0 */ ) && ($value !== 'name')) {
				switch ($value) {
					case 'posts';
						$sortColumn = 'count';
					break;
				}
			}
			$value = \KocujSitemapPlugin\Classes\Base::getInstance()->getKocujInternalLibObj()->getComponent('all', 'config')->getOption('DisplayTagsOrder');
			$sortOrder = 'ASC';
			if (isset($value[0]) /* strlen($value) > 0 */ ) {
				switch ($value) {
					case 'desc':
						$sortOrder = 'DESC';
					break;
				}
			}
			$isCloud = \KocujSitemapPlugin\Classes\Base::getInstance()->getKocujInternalLibObj()->getComponent('all', 'config')->getOption('DisplayTagsCloud');
			if ($isCloud) {
				$prior = \KocujInternalLib\V5a\Classes\Helper::getInstance()->calculateMaxPriority('wp_generate_tag_cloud');
				add_filter('wp_generate_tag_cloud', array($this, 'filterWPGenerateTagCloud'), $prior, 2);
				$pars = array(
					'separator' => ' ',
					'number'    => \KocujSitemapPlugin\Classes\Base::getInstance()->getKocujInternalLibObj()->getComponent('all', 'config')->getOption('DisplayTagsCloudNumber'),
					'orderby'   => $sortColumn,
					'order'     => $sortOrder,
				);
				$pars = apply_filters('kocujsitemap_tagscloudparameters', $pars, $locale);
				$pars['link'] = 'view';
				$pars['format'] = 'array';
				$pars['echo'] = 0;
				\KocujSitemapPlugin\Classes\MultipleLanguages::getInstance()->beforeGetTags($locale);
				$this->localeTemp = $locale;
				$this->parsTemp = $pars;
				$cloud = wp_tag_cloud($pars);
				$this->localeTemp = '';
				$this->parsTemp = array();
				remove_filter('wp_generate_tag_cloud', array($this, 'filterWPGenerateTagCloud'), $prior);
				if (!empty($cloud)) {
					$loopCount = count($cloud);
					for ($z=0; $z<$loopCount; $z++) {
						$tag = $cloud[$z];
						$arrayAdd = array(
							'id' => $tag['id'],
							'tp' => $tag['tp'],
							'cp' => $tag['cp'],
							'sc' => true,
							'lk' => $tag['lk'],
						);
						if ($z < $loopCount-1) {
							$arrayAdd['lk'] .= $pars['separator'];
						}
						if (isset($tag['ch'])) {
							$arrayAdd['ch'] = $tag['ch'];
						}
						if (isset($tag['ac'])) {
							$arrayAdd['ac'] = $tag['ac'];
						}
						$array[] = $arrayAdd;
					}
				}
			} else {
				$onlyUsed = \KocujSitemapPlugin\Classes\Base::getInstance()->getKocujInternalLibObj()->getComponent('all', 'config')->getOption('DisplayTagsUsed');
				$array = $this->getTagsData($sortColumn, $sortOrder, 0, $onlyUsed, $locale);
			}
		}
		// exit
		return $array;
	}

	/**
	 * Get administration page settings
	 *
	 * @access public
	 * @return array Administration page settings
	 */
	public function getAdminPageSettings() {
		// get administration page settings
		return array(
			'title' => __('Tags list options', 'kocuj-sitemap'),
			'id'    => 'tags_options',
			'tabs'  => array(
				'tags_displaying' => __('Displaying tags', 'kocuj-sitemap'),
				'tags_options'    => __('Options', 'kocuj-sitemap'),
			),
			'help'  => array(
				'overview' => array(
					'title'   => __('Overview', 'kocuj-sitemap'),
					'content' =>
						__('This is the place where you can enable or disable displaying of tags in the sitemap. Here you can also change how they will be displayed.', 'kocuj-sitemap').'</p>'.
						'<p>'.__('Options are divided into three tabs: `displaying tags`, `options` and `section title`. Each tab can be selected by clicking on it.', 'kocuj-sitemap').'</p>'.
						'<p>'.__('To save changed settings, click on the button `save tags list options`.', 'kocuj-sitemap'),
				),
				'displaying_tags' => array(
					'title'   => __('`Displaying tags` tab', 'kocuj-sitemap'),
					'content' =>
						__('There are the following options in this tab:', 'kocuj-sitemap').'</p>'.
						'<p><ul>'.
						'<li><em>`'.__('Display tags', 'kocuj-sitemap').'`</em>: '.__('If this option is activated, there will be tags list displayed in the sitemap.', 'kocuj-sitemap').'</li>'.
						'</ul>',
				),
				'options' => array(
					'title'   => __('`Options` tab', 'kocuj-sitemap'),
					'content' =>
						__('There are the following options in this tab:', 'kocuj-sitemap').'</p>'.
						'<p><ul>'.
						'<li><em>`'.__('Display only used tags', 'kocuj-sitemap').'`</em>: '.__('If this option is activated, there will be displayed only tags used in at least one post. This option has no effect if option `display tags as cloud` is checked.', 'kocuj-sitemap').
						'<li><em>`'.__('Display tags as cloud', 'kocuj-sitemap').'`</em>: '.__('If this option is activated, tags will be displayed as cloud instead of list. This option has effect only for tags used by at least one post.', 'kocuj-sitemap').
						'<li><em>`'.__('Number of tags to display in cloud', 'kocuj-sitemap').'`</em>: '.__('You can specify the number of tags that will be displayed in the tags cloud. If you enter here the number greater than the quantity of tags decreased by 1, then all tags will be displayed. Enter here `0` to display all tags in the sitemap.', 'kocuj-sitemap').'</li>'.
						'<li><em>`'.__('Sort tags by', 'kocuj-sitemap').'`</em>: '.__('You can sort tags in the sitemap using the selected tags properties. There are the following tags properties to select:', 'kocuj-sitemap').
						'<ul>'.
						'<li><em>`'.__('name', 'kocuj-sitemap').'`</em>: '.__('Tags will be sorted by name.', 'kocuj-sitemap').'</li>'.
						'<li><em>`'.__('posts count', 'kocuj-sitemap').'`</em>: '.__('Tags will be sorted by posts count.', 'kocuj-sitemap').'</li>'.
						'</ul>'.
						'</li>'.
						'<li><em>`'.__('Sort tags order', 'kocuj-sitemap').'`</em>: '.__('You can sort tags by ascending or descending order.', 'kocuj-sitemap').'</li>'.
						'</ul>',
				),
				'section_title' => array(
					'title'   => __('`Section title` tab', 'kocuj-sitemap'),
					'content' =>
						__('In this tab you can set the title of the section with tags. It is used if option `divide display into sections` in the main settings of the Kocuj Sitemap plugin is activated.', 'kocuj-sitemap').'</p>'.
						'<p>'.__('There are fields to enter the section title for each language that is available in your WordPress installation. If you have not activated any of the supported plugins for multilingualism, there will be visible only two fields to enter the title - for current WordPress language and for default section title in English language.', 'kocuj-sitemap').'</p>'.
						'<p>'.__('It is not necessary to enter section titles here. However, the place is here in order to be able to display the title of the section in your chosen language if there is no translation for it. If you leave this empty and if you will not have a translation of section title for current language and for default language (English language), there will be displayed the standard section title in English language.', 'kocuj-sitemap'),
				),
			),
		);
	}

	/**
	 * Get administration page data
	 *
	 * @access public
	 * @return array Administration page data
	 */
	public function getAdminPageData() {
		// get administration page data
		$sortArray = array(
			'name'  => __('name', 'kocuj-sitemap'),
			'posts' => __('posts count', 'kocuj-sitemap'),
		);
		$sortByArray = array(
			'asc'  => __('ascending', 'kocuj-sitemap'),
			'desc' => __('descending', 'kocuj-sitemap'),
		);
		// exit
		return array(
			'pages'   => array(
				\KocujSitemapPlugin\Classes\Base::getInstance()->getKocujInternalLibObj()->getComponent('all', 'admin')->getBlockHelper('DisplayTags', 'checkbox', __('If this option is activated, there will be tags list displayed in the sitemap.', 'kocuj-sitemap')),
				\KocujSitemapPlugin\Classes\Base::getInstance()->getKocujInternalLibObj()->getComponent('all', 'admin')->getBlockHelper('DisplayTagsUsed', 'checkbox', __('If this option is activated, there will be displayed only tags used in at least one post.', 'kocuj-sitemap'), array(), __('(if tags are set to display as the cloud, this option has no effect)', 'kocuj-sitemap')).
					\KocujSitemapPlugin\Classes\Base::getInstance()->getKocujInternalLibObj()->getComponent('all', 'admin')->getBlockHelper('DisplayTagsCloud', 'checkbox', __('If this option is activated, tags will be displayed as cloud instead of list.', 'kocuj-sitemap'), array(), __('(only used tags will be shown)', 'kocuj-sitemap')).
					\KocujSitemapPlugin\Classes\Base::getInstance()->getKocujInternalLibObj()->getComponent('all', 'admin')->getBlockHelper('DisplayTagsCloudNumber', 'text', __('You can specify the number of tags that will be displayed in the tags cloud. Enter here `0` to display all tags in the sitemap.', 'kocuj-sitemap'), array(), __('(`0` means all tags)', 'kocuj-sitemap')).
					\KocujSitemapPlugin\Classes\Base::getInstance()->getKocujInternalLibObj()->getComponent('all', 'admin')->getBlockHelper('DisplayTagsSort', 'select', __('You can sort tags in the sitemap using the selected tags properties.', 'kocuj-sitemap'), $sortArray).
					\KocujSitemapPlugin\Classes\Base::getInstance()->getKocujInternalLibObj()->getComponent('all', 'admin')->getBlockHelper('DisplayTagsOrder', 'select', __('You can sort tags by ascending or descending order.', 'kocuj-sitemap'), $sortByArray),
			),
			'submit'  => array(
				'title' => __('Save tags list options', 'kocuj-sitemap'),
				'info'  => __('Save current tags list options', 'kocuj-sitemap'),
			),
			'buttons' => '',
		);
	}

	/**
	 * Get administration panel order name
	 *
	 * @access public
	 * @return string Administration panel order name
	 */
	public function getAdminOrderName() {
		// get administration panel order name
		return __('Tags', 'kocuj-sitemap');
	}

	/**
	 * Get administration cache actions
	 *
	 * @access public
	 * @return array Administration cache actions
	 */
	public function getAdminCacheActions() {
		// get administration cache actions
		return array(
			'created_term',
			'delete_term',
			'edited_term',
		);
	}

	/**
	 * Get administration cache filters
	 *
	 * @access public
	 * @return array Administration cache filters
	 */
	public function getAdminCacheFilters() {
		// get administration cache filters
		return array();
	}
}
