<?php

/**
 * review-message.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU General Public License v2 or later
 * @copyright Copyright (c) 2013-2016 Dominik Kocuj
 * @package kocuj_sitemap
 */

// set namespace
namespace KocujSitemapPlugin\Classes\KocujInternalLibStrings\Backend;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * \KocujInternalLib\V5a\Classes\Project\Components\Backend\ReviewMessage classes strings
 *
 * @access public
 */
class ReviewMessage implements \KocujInternalLib\V5a\Interfaces\Strings {
	/**
	 * Singleton instance
	 *
	 * @access private
	 * @var object
	 */
	private static $instance = NULL;

	/**
	 * Constructor
	 *
	 * @access private
	 * @return void
	 */
	private function __construct() {
	}

	/**
	 * Disable cloning of object
	 *
	 * @access private
	 * @return void
	 */
	private function __clone() {
	}

	/**
	 * Get singleton instance
	 *
	 * @access public
	 * @return object Singleton instance
	 */
	public static function getInstance() {
		// optionally create new instance
		if (!self::$instance) {
			self::$instance = new self();
		}
		// exit
		return self::$instance;
	}

	/**
	 * Get string
	 *
	 * @access public
	 * @param string $id String id
	 * @return string Output string
	 */
	public function getString($id) {
		// get string
		switch ($id) {
			case 'ACTION_ADMIN_HEAD_PLUGIN_DAYS':
				/* translators: 1: plugin name, 2: days count from installation date of this plugin */
				return __('Thank you for using plugin %1$s more than %2$d days.', 'kocuj-sitemap');
			case 'ACTION_ADMIN_HEAD_THINGS_SUPPORT_PLUGIN':
				return __('Please, consider to do some things that will support this plugin.', 'kocuj-sitemap');
			case 'ACTION_ADMIN_HEAD_THEME_DAYS':
				/* translators: 1: theme name, 2: days count from installation date of this theme */
				return __('Thank you for using theme %1$s more than %2$d days.', 'kocuj-sitemap');
			case 'ACTION_ADMIN_HEAD_THINGS_SUPPORT_THEME':
				return __('Please, consider to do some things that will support this theme.', 'kocuj-sitemap');
			case 'ACTION_ADMIN_HEAD_VOTE_PLUGIN':
				return __('Vote for this plugin', 'kocuj-sitemap');
			case 'ACTION_ADMIN_HEAD_VOTE_THEME':
				return __('Vote for this theme', 'kocuj-sitemap');
			case 'ACTION_ADMIN_HEAD_TWITTER':
				return __('Tell friends on Twitter', 'kocuj-sitemap');
			case 'ACTION_ADMIN_HEAD_FACEBOOK':
				return __('Tell friends on Facebook', 'kocuj-sitemap');
			case 'ACTION_ADMIN_HEAD_NEWS_CHANNELS_TEXT_PLUGIN':
				return __('News channels for this plugin', 'kocuj-sitemap');
			case 'ACTION_ADMIN_HEAD_NEWS_CHANNELS_TEXT_THEME':
				return __('News channels for this theme', 'kocuj-sitemap');
		}
		// exit
		return '';
	}
}
