<?php

/**
 * license.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU General Public License v2 or later
 * @copyright Copyright (c) 2013-2016 Dominik Kocuj
 * @package kocuj_sitemap
 */

// set namespace
namespace KocujSitemapPlugin\Classes\KocujInternalLibStrings\Backend;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * \KocujInternalLib\V5a\Classes\Project\Components\Backend\License classes strings
 *
 * @access public
 */
class License implements \KocujInternalLib\V5a\Interfaces\Strings {
	/**
	 * Singleton instance
	 *
	 * @access private
	 * @var object
	 */
	private static $instance = NULL;

	/**
	 * Constructor
	 *
	 * @access private
	 * @return void
	 */
	private function __construct() {
	}

	/**
	 * Disable cloning of object
	 *
	 * @access private
	 * @return void
	 */
	private function __clone() {
	}

	/**
	 * Get singleton instance
	 *
	 * @access public
	 * @return object Singleton instance
	 */
	public static function getInstance() {
		// optionally create new instance
		if (!self::$instance) {
			self::$instance = new self();
		}
		// exit
		return self::$instance;
	}

	/**
	 * Get string
	 *
	 * @access public
	 * @param string $id String id
	 * @return string Output string
	 */
	public function getString($id) {
		// get string
		switch ($id) {
			case 'ACTION_ADMIN_FOOTER_LICENSE_SCRIPT_LOADING':
				return __('Loading, please wait...', 'kocuj-sitemap');
			case 'ACTION_ADMIN_FOOTER_LICENSE_SCRIPT_LOADING_ERROR':
				return __('Loading error! Please, check your internet connection and refresh page to try again.', 'kocuj-sitemap');
			case 'ACTION_ADMIN_FOOTER_LICENSE_SCRIPT_LICENSE':
				return __('License', 'kocuj-sitemap');
			case 'ACTION_ADMIN_FOOTER_LICENSE_SCRIPT_ACCEPT':
				return __('Click here to accept this license', 'kocuj-sitemap');
			case 'ACTION_ADMIN_FOOTER_LICENSE_SCRIPT_CANCEL':
				return __('If you do not agree with this license, please remove all related files', 'kocuj-sitemap');
			case 'ACTION_PRINT_FOOTER_SCRIPTS_LICENSE_PLUGIN':
				return __('License for plugin', 'kocuj-sitemap');
			case 'ACTION_PRINT_FOOTER_SCRIPTS_LICENSE_THEME':
				return __('License for theme', 'kocuj-sitemap');
		}
		// exit
		return '';
	}
}
