<?php

/**
 * exception.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU General Public License v2 or later
 * @copyright Copyright (c) 2016 Dominik Kocuj
 * @package kocuj_internal_lib\kocuj_pl_lib
 */

// set namespace
namespace KocujPlLib\V5a\Classes;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Exception class
 *
 * @access public
 */
final class Exception extends \KocujInternalLib\V5a\Classes\Exception {
	/**
	 * Set errors data
	 *
	 * @access protected
	 * @return void
	 */
	protected function setErrors() {
		// initialize errors
		$this->errors = array(
			ExceptionCode::OK                                       => 'OK',
			ExceptionCode::OBJECT_IS_NOT_KOCUJ_INTERNAL_LIB_PROJECT => 'Object is not Kocuj Internal Lib project',
			ExceptionCode::NO_REQUIRED_SETTING_DATA                 => 'No required setting data',
		);
	}
}
